package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.SxRowProcessor;

import org.apache.commons.dbutils.ResultSetHandler;

/**
 * 最初の1行のみを処理するハンドラです。
 * 1行も取得できなかった場合はnullを返します。
 * @author chinpei
 *
 */
public class SingleHandler implements ResultSetHandler {

	protected final SxRowProcessor processor;

	public SingleHandler(SxRowProcessor processor) {
		this.processor = processor;
	}

	public Object handle(ResultSet rs) throws SQLException {
		if (rs.next()) {
			processor.init(rs.getMetaData());
			return processor.process(rs);
		}
		return null;

	}

}
