package jp.sourceforge.sxdbutils.types;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ShortType extends AbstractValueType {
	private static final Short ZERO = new Short((short) 0);
	private final boolean primitive;

	public ShortType(boolean primitive) {
		this.primitive = primitive;
	}

	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		BigDecimal bd = rset.getBigDecimal(columnIndex);
		if (bd == null)
			return primitive ? ZERO : null;
		return new Short(bd.shortValue());
	}
	// protected int getSqlType() {
	// return Types.SMALLINT;
	// }

}
