package jp.sourceforge.sxdbutils.query;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import jp.sourceforge.sxdbutils.util.QueryUtil;

/**
 * SQLのを発行するために必要な、SQLとバインドパラメータを一緒に保持します。 このクラスは作成したあとに変更はできません。
 * 
 * @author chinpei
 * 
 */
public class Query {
	protected final StringBuffer sql;
	protected final List parameters;

	public Query(String sql, List parameters) {
		this.sql = new StringBuffer(sql);
		this.parameters = parameters;
	}

	public Query join(Query other) {
		Query result = new Query(this.sql.toString(), new ArrayList(
				this.parameters));
		result.sql.append(other.sql);
		result.parameters.addAll(other.parameters);
		return result;
	}

	public String getSql() {
		return sql.toString();
	}

	public Object[] getParameters() {
		return parameters.toArray();
	}

	public String literal() {

		if (QueryUtil.isBlank(sql))
			return "";
		StringBuffer builder = new StringBuffer(sql.toString());
		for (int i = 0; i < this.parameters.size(); i++) {
			QueryUtil.replace(builder, "?", toNativeParameter(this.parameters
					.get(i)));
		}
		return builder.toString();
	}

	public String toString() {
		StringBuffer builder = new StringBuffer(sql.toString());
		builder.append('\n');
		builder.append("==parameter====================\n");
		for (int i = 0; i < this.parameters.size(); i++) {
			Object parameter = this.parameters.get(i);
			DecimalFormat format = new DecimalFormat("000");
			builder.append(format.format(i));
			builder.append('\t');
			if (parameter == null) {
				builder.append("null\n");
			} else if (parameter.getClass().isAssignableFrom(byte[].class)) {
				builder.append("<<binary>>\n");
			} else {
				builder.append(
						parameter.getClass().getName() + "\t#" + parameter)
						.append("\n");
			}
		}
		builder.append("====================parameter==\n");

		return builder.toString();
	}

	private static String toNativeParameter(Object obj) {
		if (obj == null) {
			return "null";
		}
		if (obj instanceof Number) {
			return obj.toString();
		}
		if (obj instanceof java.util.Date) {
			return "'" + QueryUtil.sqlDateFormat((java.util.Date) obj) + "'";
		}
		if (obj instanceof Calendar) {
			return "'" + QueryUtil.sqlDateFormat((Calendar) obj) + "'";
		}
		if (obj.getClass().isAssignableFrom(byte[].class)) {
			return "<<binary>>";
		}

		return "'" + obj + "'";
	}
}
