package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.sxdbutils.SxRowProcessor;

import org.apache.commons.dbutils.ResultSetHandler;

/**
 * 複数行を処理するハンドラです。
 * @author chinpei
 *
 */
public class ListHandler implements ResultSetHandler {

	protected final SxRowProcessor processor;

	public ListHandler(SxRowProcessor processor) {
		this.processor = processor;
	}

	public Object handle(ResultSet rs) throws SQLException {
		List rows = new ArrayList();
		if (rs.next()) {
			processor.init(rs.getMetaData());
			do {
				rows.add(processor.process(rs));
			} while (rs.next());
		}
		return rows;
	}

}
