package jp.sourceforge.sxdbutils.bean;

import java.beans.PropertyDescriptor;
import java.util.Map;

/**
 * マッピングする「中間マッピング名」を生成する。
 * 
 * SxDbUtilsは、中間マッピング名が一致するカラムとプロパティをマッピングします。
 * 
 * @author chinpei
 * 
 */
public interface NameMapping {
	/**
	 * カラム名から中間マッピング名を生成する。
	 * 
	 * @param columnName
	 * @return
	 */
	String toIntermediateName(String columnName);

	/**
	 * プロパティから中間マッピング名を生成する。
	 * 
	 * @param propertyDescriptor
	 * @return
	 */
	String toIntermediateName(PropertyDescriptor propertyDescriptor);
	
	/**
	 * プロパティからカラム名を生成する。
	 * 
	 * @param propertyDescriptor
	 * @return
	 */
	String toColumnName(PropertyDescriptor propertyDescriptor);

	/**
	 * 中間マッピング名の一致に使われるMapを生成する。
	 * 
	 * @return
	 */
	Map createIntermediateMap();

}
