package jp.sourceforge.sxdbutils.tiger.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.sxdbutils.tiger.SxResultSetHandler;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;

/**
 * 複数行を処理するハンドラです。
 * 
 * @author chinpei
 * 
 */
public class ListHandler<S> implements SxResultSetHandler<List<S>> {

	protected final SxRowProcessor<S> processor;

	public ListHandler(SxRowProcessor<S> processor) {
		this.processor = processor;
	}

	public List<S> handle(ResultSet rs) throws SQLException {
		List<S> rows = new ArrayList<S>();
		if (rs.next()) {
			processor.init(rs.getMetaData());
			do {
				rows.add(processor.process(rs));
			} while (rs.next());
		}
		return rows;
	}

}
