package jp.sourceforge.sxdbutils.types;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class DateTimestampType extends AbstractValueType {
	/*
	 * (non-Javadoc)
	 * 
	 * @see dbutilsx.types.ValueType#getValue(java.sql.ResultSet, int)
	 */
	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		return rset.getTimestamp(columnIndex);
	}

	public Object toBindParameterValue(Object value) {
		return value == null ? null : new Timestamp(((Date) value).getTime());
	}
	// protected int getSqlType() {
	// return Types.TIMESTAMP;
	// }

}
