/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class LengthFilter
extends TokenFilter {
    final int min;
    final int max;

    public LengthFilter(TokenStream in, int min2, int max2) {
        super(in);
        this.min = min2;
        this.max = max2;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            int len = token.termText().length();
            if (len >= this.min && len <= this.max) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

