/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.xhtml2scorm;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class MyLSResourceResolver
implements LSResourceResolver {
    static final String schemaRepository = "/jp/ac/do_johodai/j314/xhtml2scorm/schemas/";
    static HashMap<String, String> catalog = null;

    MyLSResourceResolver() {
        if (catalog == null) {
            this.makeCatalog();
        }
    }

    void makeCatalog() {
        try {
            catalog = new HashMap();
            InputStream is = this.getClass().getResourceAsStream("/jp/ac/do_johodai/j314/xhtml2scorm/schemas/catalog.txt");
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                int i = line.indexOf(" @@@ ");
                String key = line.substring(0, i);
                String value = line.substring(i + 5);
                catalog.put(key, value);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            catalog = null;
        }
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream("".getBytes());
            DOMImplementationRegistry dir = DOMImplementationRegistry.newInstance();
            DOMImplementationLS di = (DOMImplementationLS)((Object)dir.getDOMImplementation("LS 3.0"));
            LSInput in = di.createLSInput();
            in.setByteStream(bais);
            return in;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public LSInput resolveResource_BAK(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String id = null;
        if (type.equals("http://www.w3.org/TR/REC-xml")) {
            id = publicId;
        } else if (type.equals("http://www.w3.org/2001/XMLSchema")) {
            id = namespaceURI;
        } else {
            System.out.println("*** NO SCHEMA ***");
            this.printInfo(type, namespaceURI, publicId, systemId, baseURI);
            return null;
        }
        String filename = catalog.get(id);
        if (filename == null) {
            System.out.println("*** NO SCHEMA ***");
            this.printInfo(type, namespaceURI, publicId, systemId, baseURI);
            return null;
        }
        return this.makeLSInput(schemaRepository + filename);
    }

    LSInput makeLSInput(String schema) {
        try {
            InputStream is = this.getClass().getResourceAsStream(schema);
            DOMImplementationRegistry dir = DOMImplementationRegistry.newInstance();
            DOMImplementationLS di = (DOMImplementationLS)((Object)dir.getDOMImplementation("LS 3.0"));
            LSInput in = di.createLSInput();
            in.setByteStream(is);
            return in;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    void printInfo(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        System.out.println("-----");
        System.out.println("type        :" + type);
        System.out.println("namespaceURI:" + namespaceURI);
        System.out.println("publicId    :" + publicId);
        System.out.println("systemId    :" + systemId);
        System.out.println("baseURI     :" + baseURI);
        System.out.println("-----");
    }
}

