/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class URLHandler {
    public static final String PROPNAME = "urlhandler.props";
    private static final Map handlers;
    private static final boolean DEBUG;

    public static URLHandler get(URL url) {
        block9: {
            Method m;
            if (url == null) {
                return null;
            }
            String protocol = url.getProtocol();
            if (handlers != null && (m = (Method)handlers.get(protocol)) != null) {
                try {
                    URLHandler handler = (URLHandler)m.invoke(null, url);
                    if (handler != null) {
                        return handler;
                    }
                }
                catch (IllegalAccessException e2) {
                    if (DEBUG) {
                        System.err.println(e2);
                    }
                }
                catch (IllegalArgumentException e3) {
                    if (DEBUG) {
                        System.err.println(e3);
                    }
                }
                catch (InvocationTargetException e4) {
                    if (!DEBUG) break block9;
                    System.err.println(e4);
                }
            }
        }
        return URLHandler.getDefault(url);
    }

    protected static URLHandler getDefault(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            return new FileURLHandler(url);
        }
        if (protocol.equals("jar")) {
            return new JarURLHandler(url);
        }
        return null;
    }

    public abstract void guide(URLVisitor var1, boolean var2);

    static {
        HashMap<String, Method> h;
        block14: {
            DEBUG = ICUDebug.enabled("URLHandler");
            h = null;
            try {
                InputStream is = URLHandler.class.getResourceAsStream(PROPNAME);
                if (is == null) {
                    is = ClassLoader.getSystemClassLoader().getResourceAsStream(PROPNAME);
                }
                if (is == null) break block14;
                Class[] params = new Class[]{URL.class};
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = br.readLine();
                while (line != null) {
                    block15: {
                        if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                            int ix = line.indexOf(61);
                            if (ix == -1) {
                                if (DEBUG) {
                                    System.err.println("bad urlhandler line: '" + line + "'");
                                }
                                break;
                            }
                            String key = line.substring(0, ix).trim();
                            String value = line.substring(ix + 1).trim();
                            try {
                                Class<?> cl = Class.forName(value);
                                Method m = cl.getDeclaredMethod("get", params);
                                if (h == null) {
                                    h = new HashMap<String, Method>();
                                }
                                h.put(key, m);
                            }
                            catch (ClassNotFoundException e2) {
                                if (DEBUG) {
                                    System.err.println(e2);
                                }
                            }
                            catch (NoSuchMethodException e3) {
                                if (DEBUG) {
                                    System.err.println(e3);
                                }
                            }
                            catch (SecurityException e4) {
                                if (!DEBUG) break block15;
                                System.err.println(e4);
                            }
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (Throwable t) {
                if (!DEBUG) break block14;
                System.err.println(t);
            }
        }
        handlers = h;
    }

    public static interface URLVisitor {
        public void visit(String var1);
    }

    private static class JarURLHandler
    extends URLHandler {
        JarFile jarFile;
        String prefix;

        JarURLHandler(URL url) {
            try {
                this.prefix = url.getPath();
                int ix = this.prefix.indexOf("!/");
                if (ix >= 0) {
                    this.prefix = this.prefix.substring(ix + 2);
                }
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                this.jarFile = conn.getJarFile();
            }
            catch (Exception e2) {
                if (DEBUG) {
                    System.err.println("icurb jar error: " + e2);
                }
                throw new IllegalArgumentException("jar error: " + e2.getMessage());
            }
        }

        public void guide(URLVisitor v, boolean recurse) {
            block4: {
                try {
                    Enumeration<JarEntry> entries = this.jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String name;
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !(name = entry.getName()).startsWith(this.prefix)) continue;
                        int ix = (name = name.substring(this.prefix.length())).lastIndexOf(47);
                        if (ix != -1) {
                            if (!recurse) continue;
                            name = name.substring(ix + 1);
                        }
                        v.visit(name);
                    }
                }
                catch (Exception e2) {
                    if (!DEBUG) break block4;
                    System.err.println("icurb jar error: " + e2);
                }
            }
        }
    }

    private static class FileURLHandler
    extends URLHandler {
        File file;

        FileURLHandler(URL url) {
            this.file = new File(url.getPath());
            if (!this.file.exists()) {
                if (DEBUG) {
                    System.err.println("file does not exist");
                }
                throw new IllegalArgumentException();
            }
        }

        public void guide(URLVisitor v, boolean recurse) {
            if (this.file.isDirectory()) {
                this.process(v, recurse, this.file.listFiles());
            } else {
                v.visit(this.file.getName());
            }
        }

        private void process(URLVisitor v, boolean recurse, File[] files) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    if (!recurse) continue;
                    this.process(v, recurse, f.listFiles());
                    continue;
                }
                v.visit(f.getName());
            }
        }
    }
}

