/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.CannotEncodeCharacterException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class TestLiteralEncoding
extends ModelTestBase {
    public TestLiteralEncoding(String name) {
        super(name);
    }

    public void testX() {
        TestLiteralEncoding.assertEquals("", Util.substituteEntitiesInElementContent(""));
        TestLiteralEncoding.assertEquals("abc", Util.substituteEntitiesInElementContent("abc"));
        TestLiteralEncoding.assertEquals("a&lt;b", Util.substituteEntitiesInElementContent("a<b"));
        TestLiteralEncoding.assertEquals("a&gt;b", Util.substituteEntitiesInElementContent("a>b"));
        TestLiteralEncoding.assertEquals("a&amp;b", Util.substituteEntitiesInElementContent("a&b"));
        TestLiteralEncoding.assertEquals("a;b", Util.substituteEntitiesInElementContent("a;b"));
        TestLiteralEncoding.assertEquals("a b", Util.substituteEntitiesInElementContent("a b"));
        TestLiteralEncoding.assertEquals("a\nb", Util.substituteEntitiesInElementContent("a\nb"));
        TestLiteralEncoding.assertEquals("a'b", Util.substituteEntitiesInElementContent("a'b"));
        TestLiteralEncoding.assertEquals("a&lt;b&lt;c", Util.substituteEntitiesInElementContent("a<b<c"));
        TestLiteralEncoding.assertEquals("a&lt;b&gt;c", Util.substituteEntitiesInElementContent("a<b>c"));
        TestLiteralEncoding.assertEquals("a&lt;b&amp;c", Util.substituteEntitiesInElementContent("a<b&c"));
        TestLiteralEncoding.assertEquals("a&amp;b&amp;c", Util.substituteEntitiesInElementContent("a&b&c"));
        TestLiteralEncoding.assertEquals("a&amp;b&gt;c", Util.substituteEntitiesInElementContent("a&b>c"));
        TestLiteralEncoding.assertEquals("a&amp;b&lt;c", Util.substituteEntitiesInElementContent("a&b<c"));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("&lt;", Util.substituteStandardEntities("<"));
        TestLiteralEncoding.assertEquals("&gt;", Util.substituteStandardEntities(">"));
        TestLiteralEncoding.assertEquals("&amp;", Util.substituteStandardEntities("&"));
        TestLiteralEncoding.assertEquals("&apos;", Util.substituteStandardEntities("'"));
        TestLiteralEncoding.assertEquals("&quot;", Util.substituteStandardEntities("\""));
        TestLiteralEncoding.assertEquals("&#xA;", Util.substituteStandardEntities("\n"));
        TestLiteralEncoding.assertEquals("&#xD;", Util.substituteStandardEntities("\r"));
        TestLiteralEncoding.assertEquals("&#9;", Util.substituteStandardEntities("\t"));
        TestLiteralEncoding.assertEquals("a&lt;b&amp;c&gt;d", Util.substituteStandardEntities("a<b&c>d"));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
        TestLiteralEncoding.assertEquals("", Util.substituteStandardEntities(""));
    }

    public void testLexicalEncodingException(String lang) {
        for (char ch = '\u0000'; ch < ' '; ch = (char)((char)(ch + 1))) {
            if (ch == 10 || ch == 9 || ch == 13) continue;
            this.testThrowsBadCharacterException(ch, lang);
        }
        this.testThrowsBadCharacterException('\uffff', lang);
        this.testThrowsBadCharacterException('\ufffe', lang);
    }

    public void testBasicLexicalEncodingException() {
        this.testLexicalEncodingException("RDF/XML");
    }

    public void testPrettyLexicalEncodingException() {
        this.testLexicalEncodingException("RDF/XML-ABBREV");
    }

    private void testThrowsBadCharacterException(char badChar, String lang) {
        String badString = "" + badChar;
        Model m = ModelFactory.createDefaultModel();
        m.createResource().addProperty(RDF.value, badString);
        Writer w = new Writer(){

            public void close() throws IOException {
            }

            public void flush() throws IOException {
            }

            public void write(char[] arg0, int arg1, int arg2) throws IOException {
            }
        };
        try {
            m.write(w, lang);
            TestLiteralEncoding.fail("should trap bad character: (char)" + badChar);
        }
        catch (CannotEncodeCharacterException e2) {
            TestLiteralEncoding.assertEquals(badChar, e2.getBadChar());
            TestLiteralEncoding.assertEquals("XML", e2.getEncodingContext());
        }
    }

    public void testNoApparentCData() {
        Model m = TestLiteralEncoding.modelWithStatements("a R ']]>'");
        StringWriter s = new StringWriter();
        m.write(s, "RDF/XML-ABBREV");
        Model m2 = TestLiteralEncoding.modelWithStatements("");
        m2.read(new StringReader(s.toString()), null, "RDF/XML");
        TestLiteralEncoding.assertIsoModels(m, m2);
        TestLiteralEncoding.assertTrue(s.toString().indexOf("]]&gt;") >= 0);
        TestLiteralEncoding.assertFalse(s.toString().indexOf("]]>") >= 0);
    }
}

