/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.vocabulary.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestVocabRDF
extends ModelTestBase {
    static final String RDFns = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    public TestVocabRDF(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestVocabRDF.class);
    }

    public void testRDFVocabulary() {
        String ns = RDFns;
        TestVocabRDF.assertEquals(ns, RDF.getURI());
        TestVocabRDF.assertEquals(ns + "Alt", RDF.Alt.getURI());
        TestVocabRDF.assertEquals(ns + "Bag", RDF.Bag.getURI());
        TestVocabRDF.assertEquals(ns + "Property", RDF.Property.getURI());
        TestVocabRDF.assertEquals(ns + "Seq", RDF.Seq.getURI());
        TestVocabRDF.assertEquals(ns + "Statement", RDF.Statement.getURI());
        TestVocabRDF.assertEquals(ns + "List", RDF.List.getURI());
        TestVocabRDF.assertEquals(ns + "nil", RDF.nil.getURI());
        TestVocabRDF.assertEquals(ns + "type", RDF.type.getURI());
        TestVocabRDF.assertEquals(ns + "rest", RDF.rest.getURI());
        TestVocabRDF.assertEquals(ns + "first", RDF.first.getURI());
        TestVocabRDF.assertEquals(ns + "subject", RDF.subject.getURI());
        TestVocabRDF.assertEquals(ns + "predicate", RDF.predicate.getURI());
        TestVocabRDF.assertEquals(ns + "object", RDF.object.getURI());
        TestVocabRDF.assertEquals(ns + "value", RDF.value.getURI());
    }

    public void testLI() {
        String ns = RDFns;
        TestVocabRDF.assertEquals(ns + "_1", RDF.li(1).getURI());
        TestVocabRDF.assertEquals(ns + "_1", RDF.li(1).getURI());
        TestVocabRDF.assertEquals(ns + "_10", RDF.li(10).getURI());
        TestVocabRDF.assertEquals(ns + "_11", RDF.li(11).getURI());
        TestVocabRDF.assertEquals(ns + "_100", RDF.li(100).getURI());
        TestVocabRDF.assertEquals(ns + "_123", RDF.li(123).getURI());
        TestVocabRDF.assertEquals(ns + "_32768", RDF.li(32768).getURI());
    }

    public void testNodes() {
        TestVocabRDF.assertEquals(RDF.Alt.asNode(), RDF.Nodes.Alt);
        TestVocabRDF.assertEquals(RDF.Bag.asNode(), RDF.Nodes.Bag);
        TestVocabRDF.assertEquals(RDF.Property.asNode(), RDF.Nodes.Property);
        TestVocabRDF.assertEquals(RDF.Seq.asNode(), RDF.Nodes.Seq);
        TestVocabRDF.assertEquals(RDF.Statement.asNode(), RDF.Nodes.Statement);
        TestVocabRDF.assertEquals(RDF.List.asNode(), RDF.Nodes.List);
        TestVocabRDF.assertEquals(RDF.nil.asNode(), RDF.Nodes.nil);
        TestVocabRDF.assertEquals(RDF.type.asNode(), RDF.Nodes.type);
        TestVocabRDF.assertEquals(RDF.rest.asNode(), RDF.Nodes.rest);
        TestVocabRDF.assertEquals(RDF.first.asNode(), RDF.Nodes.first);
        TestVocabRDF.assertEquals(RDF.subject.asNode(), RDF.Nodes.subject);
        TestVocabRDF.assertEquals(RDF.predicate.asNode(), RDF.Nodes.predicate);
        TestVocabRDF.assertEquals(RDF.object.asNode(), RDF.Nodes.object);
        TestVocabRDF.assertEquals(RDF.value.asNode(), RDF.Nodes.value);
    }
}

