/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.vocabulary.test;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestSuite;

public class TestVocabJenaModelSpec
extends ModelTestBase {
    public TestVocabJenaModelSpec(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestVocabJenaModelSpec.class);
    }

    public void testURI() {
        TestVocabJenaModelSpec.assertEquals("http://jena.hpl.hp.com/2003/08/jms#", JenaModelSpec.getURI());
        TestVocabJenaModelSpec.assertEquals("http://jena.hpl.hp.com/2003/08/jms#", JenaModelSpec.getURI());
    }

    public void testProperties() {
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("loadWith"), JenaModelSpec.loadWith);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("ontLanguage"), JenaModelSpec.ontLanguage);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("docManager"), JenaModelSpec.docManager);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("importMaker"), JenaModelSpec.importMaker);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("reasonsWith"), JenaModelSpec.reasonsWith);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("ruleSetURL"), JenaModelSpec.ruleSetURL);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("ruleSet"), JenaModelSpec.ruleSet);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("schemaURL"), JenaModelSpec.schemaURL);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("hasRule"), JenaModelSpec.hasRule);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("policyPath"), JenaModelSpec.policyPath);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("hasConnection"), JenaModelSpec.hasConnection);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("dbUser"), JenaModelSpec.dbUser);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("dbPassword"), JenaModelSpec.dbPassword);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("dbURL"), JenaModelSpec.dbURL);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("dbType"), JenaModelSpec.dbType);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("dbClass"), JenaModelSpec.dbClass);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("maker"), JenaModelSpec.maker);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("reificationMode"), JenaModelSpec.reificationMode);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("reasoner"), JenaModelSpec.reasoner);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("fileBase"), JenaModelSpec.fileBase);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("typeCreatedBy"), JenaModelSpec.typeCreatedBy);
        TestVocabJenaModelSpec.assertEquals(this.jmsProperty("modelName"), JenaModelSpec.modelName);
    }

    public void testResource() {
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("MakerSpec"), JenaModelSpec.MakerSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("FileMakerSpec"), JenaModelSpec.FileMakerSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("MemMakerSpec"), JenaModelSpec.MemMakerSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("RDBMakerSpec"), JenaModelSpec.RDBMakerSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("ModelSpec"), JenaModelSpec.ModelSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("DefaultModelSpec"), JenaModelSpec.DefaultModelSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("PlainModelSpec"), JenaModelSpec.PlainModelSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("InfModelSpec"), JenaModelSpec.InfModelSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("OntModelSpec"), JenaModelSpec.OntModelSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("FileModelSpec"), JenaModelSpec.FileModelSpec);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("rsStandard"), JenaModelSpec.rsStandard);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("rsMinimal"), JenaModelSpec.rsMinimal);
        TestVocabJenaModelSpec.assertEquals(this.jmsResource("rsConvenient"), JenaModelSpec.rsConvenient);
    }

    public void testMakerSubclasses() {
        this.ensure(JenaModelSpec.MemMakerSpec, RDFS.subClassOf, JenaModelSpec.MakerSpec);
        this.ensure(JenaModelSpec.FileMakerSpec, RDFS.subClassOf, JenaModelSpec.MakerSpec);
        this.ensure(JenaModelSpec.RDBMakerSpec, RDFS.subClassOf, JenaModelSpec.MakerSpec);
    }

    public void testSpecSubclasses() {
        this.ensure(JenaModelSpec.DefaultModelSpec, RDFS.subClassOf, JenaModelSpec.ModelSpec);
        this.ensure(JenaModelSpec.PlainModelSpec, RDFS.subClassOf, JenaModelSpec.ModelSpec);
        this.ensure(JenaModelSpec.InfModelSpec, RDFS.subClassOf, JenaModelSpec.PlainModelSpec);
        this.ensure(JenaModelSpec.FileModelSpec, RDFS.subClassOf, JenaModelSpec.PlainModelSpec);
        this.ensure(JenaModelSpec.OntModelSpec, RDFS.subClassOf, JenaModelSpec.InfModelSpec);
    }

    public void testDomains() {
        this.ensure(JenaModelSpec.reificationMode, RDFS.domain, JenaModelSpec.MakerSpec);
        this.ensure(JenaModelSpec.maker, RDFS.domain, JenaModelSpec.PlainModelSpec);
        this.ensure(JenaModelSpec.modelName, RDFS.domain, JenaModelSpec.ModelSpec);
        this.ensure(JenaModelSpec.loadWith, RDFS.domain, JenaModelSpec.ModelSpec);
        this.ensure(JenaModelSpec.importMaker, RDFS.domain, JenaModelSpec.OntModelSpec);
        this.ensure(JenaModelSpec.ontLanguage, RDFS.domain, JenaModelSpec.OntModelSpec);
        this.ensure(JenaModelSpec.reasonsWith, RDFS.domain, JenaModelSpec.InfModelSpec);
        this.ensure(JenaModelSpec.fileBase, RDFS.domain, JenaModelSpec.FileMakerSpec);
    }

    protected void ensure(Resource S, Property P, RDFNode O) {
        if (!JenaModelSpec.getSchema().contains(S, P, O)) {
            TestVocabJenaModelSpec.fail("schema omits (" + TestVocabJenaModelSpec.nice(S) + " " + TestVocabJenaModelSpec.nice(P) + " " + TestVocabJenaModelSpec.nice(O) + ")");
        }
    }

    protected Resource jmsResource(String string) {
        return TestVocabJenaModelSpec.resource(JenaModelSpec.getURI() + string);
    }

    protected Property jmsProperty(String string) {
        return TestVocabJenaModelSpec.property(JenaModelSpec.getURI() + string);
    }
}

