/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.LocatorClassLoader;
import com.hp.hpl.jena.util.LocatorFile;
import com.hp.hpl.jena.util.LocatorURL;

public class TestLocators
extends ModelTestBase {
    private static final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
    private static final ClassLoader otherClassLoader = new ClassLoader(){};

    public TestLocators(String name) {
        super(name);
    }

    public void testClassLoaderLocatorEquality() {
        LocatorClassLoader A1 = new LocatorClassLoader(systemClassLoader);
        LocatorClassLoader A2 = new LocatorClassLoader(systemClassLoader);
        LocatorClassLoader B = new LocatorClassLoader(otherClassLoader);
        this.testLocatorEquality(A1, A2, B);
    }

    private void testLocatorEquality(Locator A1, Locator A2, Locator B) {
        TestLocators.assertEquals(A1, A1);
        TestLocators.assertEquals(A2, A2);
        TestLocators.assertEquals(A1, A2);
        TestLocators.assertEquals(A2, A1);
        TestLocators.assertEquals(B, B);
        TestLocators.assertDiffer(A1, B);
        TestLocators.assertDiffer(B, A1);
    }

    public void testClassLoaderLocatorHashcode() {
        TestLocators.assertEquals(systemClassLoader.hashCode(), new LocatorClassLoader(systemClassLoader).hashCode());
        TestLocators.assertEquals(otherClassLoader.hashCode(), new LocatorClassLoader(otherClassLoader).hashCode());
    }

    public void testLocatorFileEquality() {
        LocatorFile A1 = new LocatorFile("foo/bar");
        LocatorFile A2 = new LocatorFile("foo/bar");
        LocatorFile B = new LocatorFile("bill/ben");
        this.testLocatorEquality(A1, A2, B);
    }

    public void testLocatorFileHashcode() {
        this.testLocatorFileHashCode("foo/bar");
        this.testLocatorFileHashCode("bill/ben");
        this.testLocatorFileHashCode("another/night");
    }

    private void testLocatorFileHashCode(String dirName) {
        TestLocators.assertEquals(dirName.hashCode(), new LocatorFile(dirName).hashCode());
    }

    public void testLocatorURLEquality() {
        LocatorURL A1 = new LocatorURL();
        LocatorURL A2 = new LocatorURL();
        TestLocators.assertEquals(A1, A2);
        TestLocators.assertDiffer(A1, "");
    }

    public void testLocatorURLHashcode() {
        TestLocators.assertEquals(LocatorURL.class.hashCode(), new LocatorURL().hashCode());
    }
}

