/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.core.DatasetDesc;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasetUtils {
    private static Log log = LogFactory.getLog(DatasetUtils.class);

    public static Dataset createDataset(String uri, List namedSourceList) {
        return DatasetUtils.createDataset(uri, namedSourceList, null, null);
    }

    public static Dataset createDataset(String uri, List namedSourceList, FileManager fileManager, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDataset(uriList, namedSourceList, fileManager, baseURI);
    }

    public static Dataset createDataset(List uriList, List namedSourceList) {
        return DatasetUtils.createDataset(uriList, namedSourceList, null, null);
    }

    public static Dataset createDataset(List uriList, List namedSourceList, FileManager fileManager, String baseURI) {
        DataSourceImpl ds = new DataSourceImpl();
        DatasetUtils.addInGraphs(ds, uriList, namedSourceList, fileManager, baseURI);
        return ds;
    }

    public static Dataset createDataset(DatasetDesc datasetDesc) {
        return DatasetUtils.createDataset(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), null, null);
    }

    public static Dataset createDataset(DatasetDesc datasetDesc, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDataset(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), fileManager, baseURI);
    }

    public static Dataset addInGraphs(DataSource ds, List uriList, List namedSourceList) {
        return DatasetUtils.addInGraphs(ds, uriList, namedSourceList, null, null);
    }

    public static Dataset addInGraphs(DataSource ds, List uriList, List namedSourceList, FileManager fileManager, String baseURI) {
        String absURI;
        String sourceURI;
        Iterator iter;
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (ds.getDefaultModel() == null) {
            ds.setDefaultModel(GraphUtils.makeDefaultModel());
        }
        if (uriList != null) {
            iter = uriList.iterator();
            while (iter.hasNext()) {
                sourceURI = (String)iter.next();
                absURI = null;
                absURI = baseURI != null ? IRIResolver.resolve(baseURI, sourceURI) : IRIResolver.resolveGlobal(sourceURI);
                log.debug("Load(unnamed): " + sourceURI);
                fileManager.readModel(ds.getDefaultModel(), sourceURI, absURI, null);
            }
        }
        if (namedSourceList != null) {
            iter = namedSourceList.iterator();
            while (iter.hasNext()) {
                sourceURI = (String)iter.next();
                absURI = null;
                absURI = baseURI != null ? IRIResolver.resolve(baseURI, sourceURI) : IRIResolver.resolveGlobal(sourceURI);
                log.debug("Load(named): " + sourceURI + " as " + absURI);
                Model m = GraphUtils.makeDefaultModel();
                fileManager.readModel(m, sourceURI, absURI, null);
                ds.addNamedModel(absURI, m);
            }
        }
        return ds;
    }

    public static DatasetGraph createDatasetGraph(DatasetDesc datasetDesc) {
        return DatasetUtils.createDatasetGraph(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), null, null);
    }

    public static DatasetGraph createDatasetGraph(DatasetDesc datasetDesc, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDatasetGraph(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), fileManager, baseURI);
    }

    public static DatasetGraph createDatasetGraph(String uri, List namedSourceList, FileManager fileManager, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDatasetGraph(uriList, namedSourceList, fileManager, baseURI);
    }

    public static DatasetGraph createDatasetGraph(List uriList, List namedSourceList, FileManager fileManager, String baseURI) {
        DataSourceGraphImpl ds = new DataSourceGraphImpl();
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (uriList != null) {
            Model m = GraphUtils.makeDefaultModel();
            Iterator iter = uriList.iterator();
            while (iter.hasNext()) {
                String sourceURI = (String)iter.next();
                String absURI = null;
                absURI = baseURI != null ? IRIResolver.resolve(baseURI, sourceURI) : IRIResolver.resolveGlobal(sourceURI);
                log.debug("Load(unnamed): " + sourceURI);
                fileManager.readModel(m, sourceURI, absURI, null);
            }
            ds.setDefaultGraph(m.getGraph());
        } else {
            ds.setDefaultGraph(GraphUtils.makeDefaultModel().getGraph());
        }
        if (namedSourceList != null) {
            Iterator iter = namedSourceList.iterator();
            while (iter.hasNext()) {
                String sourceURI = (String)iter.next();
                String absURI = null;
                absURI = baseURI != null ? IRIResolver.resolve(baseURI, sourceURI) : IRIResolver.resolveGlobal(sourceURI);
                log.debug("Load(named): " + sourceURI + " as " + absURI);
                Model m = fileManager.loadModel(sourceURI, absURI, null);
                Node gn = Node.createURI(sourceURI);
                ds.addGraph(gn, m.getGraph());
            }
        }
        return ds;
    }
}

