/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.test.suites;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.Functions;
import com.hp.hpl.jena.sparql.util.Utils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestNodeValue
extends TestCase {
    static final double doubleAccuracy = 1.0E-8;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestNodeValue.class);
        ts.setName(Utils.classShortName(TestNodeValue.class));
        return ts;
    }

    public void testInt1() {
        NodeValue v = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not an integer: " + v, v.isInteger());
        TestNodeValue.assertFalse("Is a node: " + v, v.hasNode());
    }

    public void testInt2() {
        NodeValue v = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not an integer: " + v, v.isInteger());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testInt3() {
        NodeValue v1 = NodeValue.makeNodeInteger(5L);
        NodeValue v2 = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue("Not same integer: " + v1 + " & " + v2, v1.getInteger().equals(v2.getInteger()));
    }

    public void testFloat1() {
        NodeValue v = NodeValue.makeFloat(5.0f);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a float: " + v, v.isFloat());
        TestNodeValue.assertTrue("Float not a double: " + v, v.isDouble());
        TestNodeValue.assertFalse("No node: " + v, v.hasNode());
    }

    public void testFloat2() {
        NodeValue v = NodeValue.makeNodeFloat(5.0f);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a float: " + v, v.isDouble());
        TestNodeValue.assertTrue("Float not a double: " + v, v.isDouble());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testFloat3() {
        NodeValue v1 = NodeValue.makeNodeFloat(5.7f);
        NodeValue v2 = NodeValue.makeFloat(5.7f);
        TestNodeValue.assertTrue("Not same float: " + v1 + " & " + v2, v1.getFloat() == v2.getFloat());
        TestNodeValue.assertTrue("Not same float as double: " + v1 + " & " + v2, v1.getDouble() == v2.getDouble());
    }

    public void testDouble1() {
        NodeValue v = NodeValue.makeDouble(5.0);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a double: " + v, v.isDouble());
        TestNodeValue.assertFalse("No node: " + v, v.hasNode());
    }

    public void testDouble2() {
        NodeValue v = NodeValue.makeNodeDouble(5.0);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a double: " + v, v.isDouble());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testDouble3() {
        NodeValue v1 = NodeValue.makeNodeDouble(5.7);
        NodeValue v2 = NodeValue.makeDouble(5.7);
        TestNodeValue.assertTrue("Not same double: " + v1 + " & " + v2, v1.getDouble() == v2.getDouble());
    }

    public void testDecimal1() {
        NodeValue v = NodeValue.makeDecimal(new BigDecimal("1.3"));
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a double: " + v, v.isDecimal());
        TestNodeValue.assertFalse("Is a node: " + v, v.hasNode());
    }

    public void testDecimal2() {
        NodeValue v = NodeValue.makeNodeDecimal("1.3");
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a double: " + v, v.isDecimal());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testDecimal3() {
        NodeValue v1 = NodeValue.makeDecimal(new BigDecimal("1.3"));
        NodeValue v2 = NodeValue.makeNodeDecimal("1.3");
        TestNodeValue.assertTrue("Not same decimal: " + v1 + " & " + v2, v1.getDecimal().compareTo(v2.getDecimal()) == 0);
        TestNodeValue.assertEquals("Not same decimal by equals: " + v1 + " & " + v2, v1, v2);
    }

    public void testDateTime1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeDateTime(cal);
        TestNodeValue.assertTrue("Not a dateTime: " + v, v.isDateTime());
        TestNodeValue.assertFalse("A date: " + v, v.isDate());
    }

    public void testDateTime2() {
        NodeValue v = NodeValue.makeNodeDateTime("2005-02-18T20:39:10Z");
        TestNodeValue.assertTrue("Not a dateTime: " + v, v.isDateTime());
        TestNodeValue.assertFalse("A date: " + v, v.isDate());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testDateTime3() {
        NodeValue v1 = NodeValue.makeDateTime("2005-02-18T20:39:10Z");
        NodeValue v2 = NodeValue.makeNodeDateTime("2005-02-18T20:39:10Z");
        TestNodeValue.assertEquals("Not Calendar.equals: ", v1.getDateTime(), v2.getDateTime());
    }

    public void testDateTime4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeNode("2005-02-18T20:39:10Z", XSDDatatype.XSDdateTime);
        TestNodeValue.assertTrue("Not a dateTime: " + v, v.isDateTime());
        TestNodeValue.assertFalse("A date: " + v, v.isDate());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        Calendar cal2 = v.getDateTime();
        TestNodeValue.assertEquals("Not equal: " + v, cal1, cal2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDateTime5() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNode("2005-02-18", XSDDatatype.XSDdateTime);
            TestNodeValue.assertFalse("Date!: " + v, v.isDate());
            TestNodeValue.assertFalse("Datetime!: " + v, v.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    public void testDate1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeDate(cal);
        TestNodeValue.assertTrue("Not a date: " + v, v.isDate());
        TestNodeValue.assertFalse("A dateTime: " + v, v.isDateTime());
    }

    public void testDate2() {
        NodeValue v = NodeValue.makeNodeDate("2005-02-18");
        TestNodeValue.assertTrue("Not a date: " + v, v.isDate());
        TestNodeValue.assertFalse("A dateTime: " + v, v.isDateTime());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testDate3() {
        NodeValue v1 = NodeValue.makeDate("2005-02-18+01:00");
        NodeValue v2 = NodeValue.makeNodeDate("2005-02-18+01:00");
        TestNodeValue.assertEquals("Not Calendar.equals: ", v1.getDate(), v2.getDate());
    }

    public void testDate4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 0, 0, 0);
        NodeValue v = NodeValue.makeNode("2005-02-18Z", XSDDatatype.XSDdate);
        TestNodeValue.assertTrue("Not a date: " + v, v.isDate());
        TestNodeValue.assertFalse("A dateTime: " + v, v.isDateTime());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        Calendar cal2 = v.getDate();
        TestNodeValue.assertEquals("Not equal: " + v, cal1, cal2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDate5() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNode("2005-02-18T20:39:10Z", XSDDatatype.XSDdate);
            TestNodeValue.assertFalse("Datetime!: " + v, v.isDateTime());
            TestNodeValue.assertFalse("Date!: " + v, v.isDate());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    public void testNodeInt1() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not an integer: " + v, v.isInteger());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testNodeInt2() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a double: " + v, v.isDouble());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testNodeInt3() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not an integer: " + v, v.isInteger());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "57", actualStr);
    }

    public void testNodeInt4() {
        NodeValue v = NodeValue.makeNodeInteger(18L);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not an integer: " + v, v.isInteger());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "18", actualStr);
    }

    public void testNodeInt5() {
        NodeValue v = NodeValue.makeNodeInteger("018");
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not an integer: " + v, v.isInteger());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "018", actualStr);
    }

    public void testNodeFloat1() {
        NodeValue v = NodeValue.makeNode("57.0", XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a float: " + v, v.isFloat());
        TestNodeValue.assertTrue("Not a double(float): " + v, v.isDouble());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "\"57.0\"^^<" + XSDDatatype.XSDfloat.getURI() + ">", actualStr);
    }

    public void testNodeDouble1() {
        NodeValue v = NodeValue.makeNode("57.0e0", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a double: " + v, v.isDouble());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "57.0e0", actualStr);
    }

    public void testNodeDouble2() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a double: " + v, v.isDouble());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "\"57\"^^<" + XSDDatatype.XSDdouble.getURI() + ">", actualStr);
    }

    public void testNodeDouble3() {
        NodeValue v = NodeValue.makeNode("057.0e0", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue("Not a number: " + v, v.isNumber());
        TestNodeValue.assertTrue("Not a double: " + v, v.isDouble());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "057.0e0", actualStr);
    }

    public void testNodeBool1() {
        NodeValue v = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue("Not a boolean: " + v, v.isBoolean());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        TestNodeValue.assertTrue("Not satisfied: " + v, v.getBoolean());
    }

    public void testNodeBool2() {
        NodeValue v = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue("Not a boolean: " + v, v.isBoolean());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        TestNodeValue.assertFalse("Satisfied: " + v, v.getBoolean());
    }

    public void testNodeBool3() {
        NodeValue v = NodeValue.makeBoolean(true);
        TestNodeValue.assertTrue("Not a boolean: " + v, v.isBoolean());
        TestNodeValue.assertTrue("Not true: " + v, v.getBoolean());
        TestNodeValue.assertTrue("Not true: " + v, Functions.booleanEffectiveValue(v));
    }

    public void testNodeBool4() {
        NodeValue v = NodeValue.makeBoolean(false);
        TestNodeValue.assertTrue("Not a boolean: " + v, v.isBoolean());
        TestNodeValue.assertFalse("Not false: " + v, v.getBoolean());
        TestNodeValue.assertFalse("Not false: " + v, Functions.booleanEffectiveValue(v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial1() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger("abc");
            TestNodeValue.assertFalse("Good integer: " + v, v.isInteger());
            TestNodeValue.assertFalse("Good number: " + v, v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial2() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger("1.8");
            TestNodeValue.assertFalse("Good integer: " + v, v.isInteger());
            TestNodeValue.assertFalse("Good number: " + v, v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial3() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeDateTime("2005-10-34T00:00:01Z");
            TestNodeValue.assertFalse("Good date: " + v, v.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial4() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            String s = "2005-10-14T 09:30:23+01:00";
            NodeValue.VerboseWarnings = false;
            NodeValue v1 = NodeValue.makeDateTime(s);
            TestNodeValue.assertFalse("Good date: " + v1, v1.isDateTime());
            s = s.replaceAll(" ", "");
            NodeValue v2 = NodeValue.makeDateTime(s);
            TestNodeValue.assertTrue("Bad date: " + v2, v2.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    public void testEBV1() {
        TestNodeValue.assertTrue("Not a boolean", NodeValue.TRUE.isBoolean());
        TestNodeValue.assertTrue("Not true", NodeValue.TRUE.getBoolean());
        TestNodeValue.assertTrue("Not true", Functions.booleanEffectiveValue(NodeValue.TRUE));
    }

    public void testEBV2() {
        TestNodeValue.assertTrue("Not a boolean", NodeValue.FALSE.isBoolean());
        TestNodeValue.assertFalse("Not false", NodeValue.FALSE.getBoolean());
        TestNodeValue.assertFalse("Not false", Functions.booleanEffectiveValue(NodeValue.FALSE));
    }

    public void testEBV3() {
        NodeValue v = NodeValue.makeInteger(1L);
        TestNodeValue.assertFalse("It's a boolean: " + v, v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail("getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertTrue("Not EBV true: " + v, Functions.booleanEffectiveValue(v));
    }

    public void testEBV4() {
        NodeValue v = NodeValue.makeInteger(0L);
        TestNodeValue.assertFalse("It's a boolean: " + v, v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail("getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertFalse("Not EBV false: " + v, Functions.booleanEffectiveValue(v));
    }

    public void testEBV5() {
        NodeValue v = NodeValue.makeString("xyz");
        TestNodeValue.assertFalse("It's a boolean: " + v, v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail("getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertTrue("Not EBV true: " + v, Functions.booleanEffectiveValue(v));
    }

    public void testEBV6() {
        NodeValue v = NodeValue.makeString("");
        TestNodeValue.assertFalse("It's a boolean: " + v, v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail("getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertFalse("Not EBV false: " + v, Functions.booleanEffectiveValue(v));
    }

    public void testFloatDouble1() {
        NodeValue v1 = NodeValue.makeNodeDouble("1.5");
        NodeValue v2 = NodeValue.makeNode("1.5", XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue("Should be equal: 1.5 float and 1.5 double", NodeValue.sameAs(v1, v2));
    }

    public void testFloatDouble5() {
        NodeValue v1 = NodeValue.makeNodeDouble("1.3");
        NodeValue v2 = NodeValue.makeNode("1.3", XSDDatatype.XSDfloat);
        TestNodeValue.assertFalse("Should not be equal: 1.3 float and 1.3 double", NodeValue.sameAs(v1, v2));
    }

    public void testString1() {
        NodeValue v = NodeValue.makeString("string");
        TestNodeValue.assertTrue("Not a string: " + v, v.isString());
        TestNodeValue.assertFalse("Is a node: " + v, v.hasNode());
    }

    public void testNodeString1() {
        NodeValue v = NodeValue.makeNode("string", null, (String)null);
        TestNodeValue.assertTrue("Not a string: " + v, v.isString());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
    }

    public void testNodeString2() {
        NodeValue v = NodeValue.makeNode("string", null, (String)null);
        TestNodeValue.assertTrue("Not a string: " + v, v.isString());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "\"string\"", actualStr);
    }

    public void testNodeString3() {
        NodeValue v = NodeValue.makeNode("string", XSDDatatype.XSDstring);
        TestNodeValue.assertTrue("Not a string: " + v, v.isString());
        TestNodeValue.assertTrue("Not a node: " + v, v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals("Print form mismatch", "\"string\"^^<" + XSDDatatype.XSDstring.getURI() + ">", actualStr);
    }

    public void testSameValue1() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeInteger(7L);
        TestNodeValue.assertTrue("Same values (" + nv1 + "," + nv2 + ")", NodeValue.notSameAs(nv1, nv2));
        TestNodeValue.assertFalse("Same values (" + nv1 + "," + nv2 + ")", NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue("Different values (" + nv1 + "," + nv3 + ")", NodeValue.sameAs(nv1, nv3));
        TestNodeValue.assertFalse("Different values - notNotSame (" + nv1 + "," + nv3 + ")", NodeValue.notSameAs(nv1, nv3));
    }

    public void testSameValue2() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeNodeInteger(7L);
        TestNodeValue.assertTrue("Same values (" + nv1 + "," + nv2 + ")", NodeValue.notSameAs(nv1, nv2));
        TestNodeValue.assertFalse("Same values (" + nv1 + "," + nv2 + ")", NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue("Different values (" + nv1 + "," + nv3 + ")", NodeValue.sameAs(nv1, nv3));
        TestNodeValue.assertFalse("Different values - notNotSame (" + nv1 + "," + nv3 + ")", NodeValue.notSameAs(nv1, nv3));
    }

    public void testSameValue3() {
        NodeValue nv1 = NodeValue.makeDecimal("1.5");
        NodeValue nv2 = NodeValue.makeDecimal("1.6");
        TestNodeValue.assertTrue("Same values (" + nv1 + "," + nv2 + ")", NodeValue.notSameAs(nv1, nv2));
        TestNodeValue.assertFalse("Same values (" + nv1 + "," + nv2 + ")", NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDecimal("1.50");
        TestNodeValue.assertTrue("Different values (" + nv1 + "," + nv3 + ")", NodeValue.sameAs(nv1, nv3));
        TestNodeValue.assertFalse("Different values - notNotSame (" + nv1 + "," + nv3 + ")", NodeValue.notSameAs(nv1, nv3));
    }

    public void testSameValue4() {
        NodeValue nv1 = NodeValue.makeDecimal("3");
        NodeValue nv2 = NodeValue.makeInteger(4L);
        TestNodeValue.assertTrue("Same values (" + nv1 + "," + nv2 + ")", NodeValue.notSameAs(nv1, nv2));
        TestNodeValue.assertFalse("Same values (" + nv1 + "," + nv2 + ")", NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeInteger(3L);
        TestNodeValue.assertTrue("Different values (" + nv1 + "," + nv3 + ")", NodeValue.sameAs(nv1, nv3));
        TestNodeValue.assertFalse("Different values - notNotSame (" + nv1 + "," + nv3 + ")", NodeValue.notSameAs(nv1, nv3));
    }

    public void testSameValue5() {
        NodeValue nv1 = NodeValue.makeDecimal("-1.5");
        NodeValue nv2 = NodeValue.makeDouble(1.5);
        TestNodeValue.assertTrue("Same values (" + nv1 + "," + nv2 + ")", NodeValue.notSameAs(nv1, nv2));
        TestNodeValue.assertFalse("Same values (" + nv1 + "," + nv2 + ")", NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDouble(-1.5);
        TestNodeValue.assertTrue("Different values (" + nv1 + "," + nv3 + ")", NodeValue.sameAs(nv1, nv3));
        TestNodeValue.assertFalse("Different values - notNotSame (" + nv1 + "," + nv3 + ")", NodeValue.notSameAs(nv1, nv3));
    }

    public void testSameValue6() {
        NodeValue nv1 = NodeValue.makeNodeInteger(17L);
        NodeValue nv2 = NodeValue.makeDouble(34.0);
        TestNodeValue.assertTrue("Same values (" + nv1 + "," + nv2 + ")", NodeValue.notSameAs(nv1, nv2));
        TestNodeValue.assertFalse("Same values (" + nv1 + "," + nv2 + ")", NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDouble(17.0);
        TestNodeValue.assertTrue("Different values (" + nv1 + "," + nv3 + ")", NodeValue.sameAs(nv1, nv3));
        TestNodeValue.assertFalse("Different values - notNotSame (" + nv1 + "," + nv3 + ")", NodeValue.notSameAs(nv1, nv3));
    }

    public void testSameValue7() {
        NodeValue nv1 = NodeValue.makeBoolean(true);
        NodeValue nv2 = NodeValue.makeString("a");
        TestNodeValue.assertTrue("Same values (" + nv1 + "," + nv2 + ")", NodeValue.notSameAs(nv1, nv2));
        TestNodeValue.assertFalse("Same values (" + nv1 + "," + nv2 + ")", NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeNodeBoolean(true);
        TestNodeValue.assertTrue("Different values (" + nv1 + "," + nv3 + ")", NodeValue.sameAs(nv1, nv3));
        TestNodeValue.assertFalse("Different values - notNotSame (" + nv1 + "," + nv3 + ")", NodeValue.notSameAs(nv1, nv3));
    }

    public void testLang1() {
        Node n1 = Node.createLiteral("xyz", "en", null);
        NodeValue nv1 = NodeValue.makeNode(n1);
        Node n2 = Node.createLiteral("xyz", "en", null);
        NodeValue nv2 = NodeValue.makeNode(n2);
        TestNodeValue.assertTrue(NodeValue.sameAs(nv1, nv2));
    }

    public void testLang2() {
        Node n1 = Node.createLiteral("xyz", "en", null);
        NodeValue nv1 = NodeValue.makeNode(n1);
        Node n2 = Node.createLiteral("xyz", "EN", null);
        NodeValue nv2 = NodeValue.makeNode(n2);
        TestNodeValue.assertTrue(NodeValue.sameAs(nv1, nv2));
        TestNodeValue.assertFalse(nv1.equals(nv2));
    }

    public void testLang3() {
        Node n1 = Node.createLiteral("xyz", "en", null);
        NodeValue nv1 = NodeValue.makeNode(n1);
        Node n2 = Node.createLiteral("xyz", "en", null);
        NodeValue nv2 = NodeValue.makeNode(n2);
        TestNodeValue.assertFalse(NodeValue.notSameAs(nv1, nv2));
    }

    public void testLang4() {
        Node n1 = Node.createLiteral("xyz", "en", null);
        NodeValue nv1 = NodeValue.makeNode(n1);
        Node n2 = Node.createLiteral("xyz", "EN", null);
        NodeValue nv2 = NodeValue.makeNode(n2);
        TestNodeValue.assertFalse(NodeValue.notSameAs(nv1, nv2));
        TestNodeValue.assertFalse(nv1.equals(nv2));
    }

    public void testEquals1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(1L);
        TestNodeValue.assertEquals("Not NodeValue.equals()", nv1, nv2);
    }

    public void testEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(1L);
        TestNodeValue.assertEquals("Not NodeValue.equals()", nv1, nv2);
    }

    public void testEquals3() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeNodeInteger(1L);
        TestNodeValue.assertEquals("Not NodeValue.equals()", nv1, nv2);
    }

    public void testEquals4() {
        NodeValue nv1 = NodeValue.makeNode(Node.createURI("http://example"));
        NodeValue nv2 = NodeValue.makeNode(Node.createURI("http://example"));
        TestNodeValue.assertEquals("Not NodeValue.equals()", nv1, nv2);
    }

    public void testNotEquals1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        TestNodeValue.assertFalse("NodeValue.equals()", nv1.equals(nv2));
    }

    public void testNotEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger(1L);
        NodeValue nv2 = NodeValue.makeNodeString("1");
        TestNodeValue.assertFalse("NodeValue.equals()", nv1.equals(nv2));
    }

    public void testNotEquals3() {
        NodeValue nv1 = NodeValue.makeNode(Node.createURI("http://example"));
        NodeValue nv2 = NodeValue.makeNode(Node.createLiteral("http://example"));
        TestNodeValue.assertFalse("NodeValue.equals()", nv1.equals(nv2));
    }
}

