/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.FmtExprARQ;
import com.hp.hpl.jena.sparql.serializer.FmtTemplateARQ;
import com.hp.hpl.jena.sparql.serializer.FormatterARQ;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.QuerySerializer;
import com.hp.hpl.jena.sparql.serializer.QuerySerializerPlain;
import com.hp.hpl.jena.sparql.serializer.QuerySerializerPrefix;
import com.hp.hpl.jena.sparql.serializer.QuerySerializerXML;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.NodeToLabelMap;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Serializer {
    static final int BLOCK_INDENT = 2;
    private static Log log = LogFactory.getLog(Serializer.class);

    public static void serialize(Query query2, OutputStream out) {
        Serializer.serialize(query2, out, null);
    }

    public static void serialize(Query query2, OutputStream out, Syntax syntax) {
        IndentedWriter writer = new IndentedWriter(out);
        Serializer.serialize(query2, writer, syntax);
        writer.flush();
        try {
            out.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void serialize(Query query2, IndentedLineBuffer buff) {
        Syntax s = query2.getSyntax();
        if (s == null) {
            s = Syntax.syntaxSPARQL;
        }
        Serializer.serialize(query2, buff, s);
    }

    public static void serialize(Query query2, IndentedLineBuffer buff, Syntax outSyntax) {
        Serializer.serialize(query2, buff.getIndentedWriter(), outSyntax);
    }

    public static void serialize(Query query2, IndentedWriter writer) {
        Syntax s = query2.getSyntax();
        if (s == null) {
            s = Syntax.syntaxSPARQL;
        }
        Serializer.serialize(query2, writer, s);
    }

    public static void serialize(Query query2, IndentedWriter writer, Syntax outSyntax) {
        if (outSyntax == null) {
            outSyntax = Syntax.syntaxSPARQL;
        }
        if (outSyntax.equals(Syntax.syntaxARQ)) {
            Serializer.serializeARQ(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxRDQL)) {
            Serializer.serializeRDQL(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL)) {
            Serializer.serializeSPARQL(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL_X)) {
            Serializer.serializeSPARQL_X(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL)) {
            Serializer.serializeSPARQL(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxN3QL)) {
            Serializer.serializeN3QL(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxPrefix)) {
            Serializer.serializePrefix(query2, writer);
            return;
        }
        if (outSyntax.equals(Syntax.syntaxDebug)) {
            Serializer.serializePlain(query2, writer);
            return;
        }
        log.warn("Unknown syntax: " + outSyntax);
    }

    public static void serializeARQ(Query query2, IndentedWriter writer) {
        SerializationContext cxt1 = new SerializationContext(query2, new NodeToLabelMap("b", false));
        SerializationContext cxt2 = new SerializationContext(query2, new NodeToLabelMap("c", false));
        Serializer.serializeARQ(query2, writer, new FormatterARQ(writer, cxt1), new FmtExprARQ(writer, cxt1), new FmtTemplateARQ(writer, cxt2));
    }

    private static void serializeARQ(Query query2, IndentedWriter writer, FormatterElement eltFmt, FmtExpr exprFmt, FormatterTemplate templateFmt) {
        QuerySerializer serilizer = new QuerySerializer(writer, eltFmt, exprFmt, templateFmt);
        query2.visit(serilizer);
    }

    public static void serializeSPARQL(Query query2, IndentedWriter writer) {
        Serializer.serializeARQ(query2, writer);
    }

    public static void serializeSPARQL_X(Query query2, IndentedWriter writer) {
        SerializationContext cxt = new SerializationContext(query2, null);
        QuerySerializerXML serilizer = new QuerySerializerXML(writer, cxt);
        query2.visit(serilizer);
    }

    public static void serializeRDQL(Query query2, IndentedWriter writer) {
        log.warn("# unparseRDQL: Not implemented - Native syntax instead");
        Serializer.serializeARQ(query2, writer);
    }

    public static void serializePrefix(Query query2, IndentedWriter writer) {
        SerializationContext cxt = new SerializationContext(query2, null);
        QuerySerializerPrefix serializer = new QuerySerializerPrefix(writer, cxt);
        query2.visit(serializer);
    }

    public static void serializePlain(Query query2, IndentedWriter writer) {
        SerializationContext cxt = new SerializationContext(query2, null);
        QuerySerializerPlain serializer = new QuerySerializerPlain(writer, cxt);
        query2.visit(serializer);
    }

    public static void serializeN3QL(Query query2, IndentedWriter writer) {
        throw new UnsupportedOperationException("Not implemented: Formatting a query in N3QL syntax");
    }
}

