/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.FmtExprPrefix;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterPrefix;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuerySerializerPrefix
implements QueryVisitor {
    protected FormatterTemplate fmtTemplate;
    protected FormatterElement fmtElement;
    protected FmtExpr fmtExpr;
    protected IndentedWriter out = null;
    static final int INDENT = 2;
    static final boolean closingBracketOnSameLine = true;

    QuerySerializerPrefix(OutputStream outStream, SerializationContext context) {
        this(new IndentedWriter(outStream), context);
    }

    QuerySerializerPrefix(IndentedWriter iwriter, SerializationContext context) {
        FormatterPrefix fmt = new FormatterPrefix(iwriter, context);
        this.fmtElement = fmt;
        this.fmtTemplate = fmt;
        this.fmtExpr = new FmtExprPrefix(iwriter, context);
        this.out = iwriter;
    }

    public void startVisit(Query query2) {
        this.out.println("(query ");
        this.out.incIndent(2);
    }

    public void finishVisit(Query query2) {
        this.out.decIndent(2);
        this.out.println(")");
        this.out.flush();
    }

    public void visitResultForm(Query query2) {
    }

    public void visitPrologue(Prologue prologue) {
        this.printBase(prologue);
        this.printPrefixes(prologue);
    }

    private void printBase(Prologue prologue) {
        if (prologue.explicitlySetBaseURI() && prologue.getBaseURI() != null) {
            this.out.println("(base <" + prologue.getBaseURI() + ">)");
        }
    }

    private void printPrefixes(Prologue prologue) {
        if (prologue.getPrefixMapping() == null) {
            return;
        }
        Map pmap = prologue.getPrefixMapping().getNsPrefixMap();
        Iterator iter = pmap.keySet().iterator();
        while (iter.hasNext()) {
            String k = (String)iter.next();
            String v = (String)pmap.get(k);
            this.out.println("(prefix " + k + ": <" + v + ">)");
        }
    }

    public void visitSelectResultForm(Query query2) {
        this.out.print("(select");
        if (query2.isQueryResultStar()) {
            this.out.print(" *");
        } else {
            this.writeVarList(query2.getResultVars());
        }
        this.out.println(")");
        this.resultFormModifiers(query2);
    }

    public void visitConstructResultForm(Query query2) {
        this.out.print("(construct");
        this.out.println();
        this.out.incIndent(2);
        query2.getConstructTemplate().visit(this.fmtTemplate);
        this.out.decIndent(2);
        this.out.println(")");
        this.resultFormModifiers(query2);
    }

    public void visitDescribeResultForm(Query query2) {
        this.out.print("(describe");
        this.writeVarList(query2.getResultVars());
        this.writeNodeList(query2.getResultURIs());
        this.out.println(")");
        this.resultFormModifiers(query2);
    }

    public void visitAskResultForm(Query query2) {
        this.out.print("(ask");
        this.out.incIndent(2);
        this.out.decIndent(2);
        this.out.println(")");
        this.resultFormModifiers(query2);
    }

    public void visitDatasetDecl(Query query2) {
        String $;
        String graphIRI;
        Iterator iter = query2.getGraphURIs().iterator();
        while (iter.hasNext()) {
            graphIRI = (String)iter.next();
            $ = FmtUtils.stringForNode(Node.createURI(graphIRI), query2.getPrefixMapping());
            this.out.println("(from " + $ + ")");
        }
        iter = query2.getNamedGraphURIs().iterator();
        while (iter.hasNext()) {
            graphIRI = (String)iter.next();
            $ = FmtUtils.stringForNode(Node.createURI(graphIRI), query2.getPrefixMapping());
            this.out.println("(from named " + $ + ")");
        }
    }

    public void visitQueryPattern(Query query2) {
        if (query2.getQueryPattern() != null) {
            query2.getQueryPattern().visit(this.fmtElement);
            this.out.println();
        }
    }

    public void visitOrderBy(Query query2) {
    }

    public void visitOffset(Query query2) {
    }

    public void visitLimit(Query query2) {
    }

    private void writeVarList(List vars) {
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            this.out.print(" ?" + var);
        }
    }

    private void writeNodeList(List nodes) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            this.out.print(" ");
            this.out.print(FmtUtils.stringForNode(n));
        }
    }

    private void resultFormModifiers(Query query2) {
        if (query2.hasOrderBy()) {
            Iterator iter = query2.getOrderBy().iterator();
            while (iter.hasNext()) {
                this.out.print("(order by ");
                SortCondition sc = (SortCondition)iter.next();
                sc.formatPrefix(this.fmtExpr, this.out);
                this.out.println(")");
            }
        }
        if (query2.isDistinct()) {
            this.out.println("(distinct true)");
        }
        if (query2.isReduced()) {
            this.out.println("(reduced true)");
        }
        if (query2.hasOffset()) {
            this.out.println("(offset " + query2.getOffset() + ")");
        }
        if (query2.hasLimit()) {
            this.out.println("(limit " + query2.getLimit() + ")");
        }
    }
}

