/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.NodeVar;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class FmtExprPrefix
extends FmtExpr {
    static final boolean ONELINE = true;
    IndentedWriter out;
    SerializationContext context;

    public FmtExprPrefix(IndentedWriter writer, PrefixMapping pm) {
        this(writer, new SerializationContext(pm, null));
    }

    public FmtExprPrefix(IndentedWriter writer, SerializationContext qCxt) {
        this.out = writer;
        this.context = qCxt;
        if (this.context == null) {
            this.context = new SerializationContext();
        }
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Expr expr) {
        FmtExprPrefix fmt = new FmtExprPrefix(out, cxt);
        fmt.startVisit();
        expr.visit(fmt);
        fmt.finishVisit();
    }

    public void startVisit() {
    }

    public void visit(ExprFunction func) {
        Expr expr;
        this.out.print("(");
        String n = null;
        if (func.getOpName() != null) {
            n = func.getOpName();
        }
        if (n == null) {
            n = func.getFunctionPrintName(this.context);
        }
        this.out.print(n);
        this.out.incIndent(2);
        int i = 1;
        while ((expr = func.getArg(i)) != null) {
            this.out.print(' ');
            expr.visit(this);
            ++i;
        }
        this.out.print(")");
        this.out.decIndent(2);
    }

    public void visit(NodeValue nv) {
        this.out.print(nv.asQuotedString(this.context));
    }

    public void visit(NodeVar nv) {
        this.out.print("?");
        this.out.print(nv.getVarName());
    }

    public void finishVisit() {
        this.out.flush();
    }

    private void endLine() {
        this.out.print(' ');
    }
}

