/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.resultset.ResultSetProcessor;
import com.hp.hpl.jena.sparql.resultset.XMLResults;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.RefBoolean;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class XMLOutputResultSet
implements ResultSetProcessor,
XMLResults {
    static boolean outputExplicitUnbound = false;
    static RefBoolean outputGraphBNodeLabels = new RefBoolean(ARQ.outputGraphBNodeLabels, false);
    int index = 0;
    String stylesheetURL = null;
    boolean xmlInst = true;
    IndentedWriter out;
    int bNodeCounter = 0;
    Map bNodeMap = new HashMap();

    XMLOutputResultSet(OutputStream outStream) {
        this(new IndentedWriter(outStream));
    }

    XMLOutputResultSet(IndentedWriter indentedOut) {
        this.out = indentedOut;
    }

    public void start(ResultSet rs) {
        if (this.xmlInst) {
            this.out.println("<?xml version=\"1.0\"?>");
        }
        if (this.stylesheetURL != null) {
            this.out.println("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.stylesheetURL + "\"?>");
        }
        this.out.println("<sparql");
        this.out.incIndent(2);
        this.out.incIndent(2);
        this.out.println("xmlns:rdf=\"" + ARQConstants.rdfPrefix + "\"");
        this.out.println("xmlns:xs=\"http://www.w3.org/2001/XMLSchema#\"");
        this.out.println("xmlns=\"http://www.w3.org/2005/sparql-results#\" >");
        this.out.decIndent(2);
        this.out.decIndent(2);
        this.out.incIndent(2);
        this.out.println("<head>");
        Iterator iter = rs.getResultVars().iterator();
        while (iter.hasNext()) {
            String n = (String)iter.next();
            this.out.incIndent(2);
            this.out.print("<");
            this.out.print("variable");
            this.out.print(" name=\"" + n + "\"");
            this.out.println("/>");
            this.out.decIndent(2);
        }
        this.out.println("</head>");
        this.out.decIndent(2);
        this.out.incIndent(2);
        this.out.println("<results>");
        this.out.incIndent(2);
    }

    public void finish(ResultSet rs) {
        this.out.decIndent(2);
        this.out.println("</results>");
        this.out.decIndent(2);
        this.out.println("</sparql>");
        this.out.flush();
    }

    public void start(QuerySolution qs) {
        this.out.println("<result>");
        ++this.index;
        this.out.incIndent(2);
    }

    public void finish(QuerySolution qs) {
        this.out.decIndent(2);
        this.out.println("</result>");
    }

    public void binding(String varName, RDFNode node) {
        if (node == null && !outputExplicitUnbound) {
            return;
        }
        this.out.print("<");
        this.out.print("binding");
        this.out.println(" name=\"" + varName + "\">");
        this.out.incIndent(2);
        this.printBindingValue(node);
        this.out.decIndent(2);
        this.out.println("</binding>");
    }

    void printBindingValue(RDFNode node) {
        if (node == null) {
            this.out.println("<unbound/>");
            return;
        }
        if (node instanceof Literal) {
            this.printLiteral((Literal)node);
            return;
        }
        if (node instanceof Resource) {
            this.printResource((Resource)node);
            return;
        }
        LogFactory.getLog(this.getClass()).warn("Unknown RDFNode type in result set: " + node.getClass());
    }

    void printLiteral(Literal literal) {
        String datatype = literal.getDatatypeURI();
        String lang = literal.getLanguage();
        this.out.print("<literal");
        if (lang != null && lang.length() != 0) {
            this.out.print(" xml:lang=\"" + lang + "\"");
        }
        if (datatype != null && !datatype.equals("")) {
            this.out.print(" datatype=\"" + datatype + "\"");
        }
        this.out.print(">");
        this.out.print(XMLOutputResultSet.xml_escape(literal.getLexicalForm()));
        this.out.println("</literal>");
    }

    void printResource(Resource r) {
        if (r.isAnon()) {
            String label;
            if (outputGraphBNodeLabels.getValue()) {
                label = r.asNode().getBlankNodeId().getLabelString();
            } else {
                if (!this.bNodeMap.containsKey(r)) {
                    this.bNodeMap.put(r, "b" + this.bNodeCounter++);
                }
                label = (String)this.bNodeMap.get(r);
            }
            this.out.println("<bnode>" + label + "</" + "bnode" + ">");
        } else {
            this.out.println("<uri>" + XMLOutputResultSet.xml_escape(r.getURI()) + "</" + "uri" + ">");
        }
    }

    private static String xml_escape(String string) {
        String s = string;
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("\r", "&#x0A;");
        s = s.replaceAll("\n", "&#x0D;");
        return s;
    }

    public String getStylesheetURL() {
        return this.stylesheetURL;
    }

    public void setStylesheetURL(String stylesheetURL) {
        this.stylesheetURL = stylesheetURL;
    }

    public boolean getXmlInst() {
        return this.xmlInst;
    }

    public void setXmlInst(boolean xmlInst) {
        this.xmlInst = xmlInst;
    }
}

