/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.resultset.XMLInputSAX;
import com.hp.hpl.jena.sparql.resultset.XMLInputStAX;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.sparql.util.RefBoolean;
import java.io.InputStream;

public class XMLInput {
    static RefBoolean useSAX = new RefBoolean(ARQ.useSAX);

    public static ResultSet fromXML(InputStream in) {
        return XMLInput.fromXML(in, GraphUtils.makeJenaDefaultModel());
    }

    public static ResultSet fromXML(InputStream in, Model model) {
        return XMLInput.make(in, model).getResultSet();
    }

    public static boolean booleanFromXML(InputStream in) {
        return XMLInput.make(in, null).getBooleanResult();
    }

    public static SPARQLResult make(InputStream in) {
        return XMLInput.make(in, null);
    }

    public static SPARQLResult make(InputStream in, Model model) {
        if (useSAX.getValue()) {
            return new XMLInputSAX(in, model);
        }
        return new XMLInputStAX(in, model);
    }
}

