/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.resultset.ResultSetProcessor;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;

public class PlainFormat
implements ResultSetProcessor {
    PrintWriter out;
    int count = 0;
    boolean lineNumbers = true;
    boolean first = true;
    SerializationContext context;

    public PlainFormat(OutputStream outStream, SerializationContext context) {
        this.out = FileUtils.asPrintWriterUTF8(outStream);
        this.context = context;
    }

    public PlainFormat(OutputStream outStream, PrefixMapping prefixMapping) {
        this(outStream, new SerializationContext(prefixMapping));
    }

    public void start(ResultSet rs) {
    }

    public void finish(ResultSet rs) {
        this.out.flush();
    }

    public void start(QuerySolution qs) {
        ++this.count;
        this.insertLineNumber();
        this.first = true;
    }

    public void finish(QuerySolution qs) {
        this.out.println();
    }

    public void binding(String varName, RDFNode value) {
        if (value == null) {
            return;
        }
        if (!this.first) {
            this.out.print(" ");
        }
        String s = FmtUtils.stringForRDFNode(value, this.context);
        this.out.print("( ?" + varName + " = " + s + " )");
        this.first = false;
    }

    void insertLineNumber() {
        if (!this.lineNumbers) {
            return;
        }
        String s = Integer.toString(this.count);
        for (int i = 0; i < 3 - s.length(); ++i) {
            this.out.print(' ');
        }
        this.out.print(s);
        this.out.print(' ');
    }
}

