/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.sparql.lang.rdql.ExprBoolean;
import com.hp.hpl.jena.sparql.lang.rdql.ExprNode;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.NodeValueSettable;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLQueryPrintUtils;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_NodeValue;
import com.hp.hpl.jena.sparql.lang.rdql.WorkingVar;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class Q_StringLangEqual
extends ExprNode
implements ExprRDQL,
ExprBoolean {
    ExprRDQL left;
    ExprRDQL right;
    protected static String printName = "lang=";
    protected static String opSymbol = "langeq";

    Q_StringLangEqual(int id) {
        super(id);
    }

    Q_StringLangEqual(RDQLParser p, int id) {
        super(p, id);
    }

    protected boolean rawEval(RDQL_NodeValue x, RDQL_NodeValue y) {
        if (x.isNode() && x.getNode().isLiteral() && y.isNode() && y.getNode().isLiteral()) {
            Node xNode = x.getNode();
            Node yNode = y.getNode();
            String nodeLang = xNode.getLiteralLanguage().toUpperCase();
            String queryLang = yNode.getLiteralLexicalForm().toUpperCase();
            if (queryLang.indexOf("-") >= 0) {
                return nodeLang.equals(queryLang);
            }
            int pos = nodeLang.indexOf("-");
            if (pos > 0) {
                nodeLang = nodeLang.substring(0, pos);
            }
            return nodeLang.equals(queryLang);
        }
        return false;
    }

    public RDQL_NodeValue evalRDQL(Query q, IndexValues env) {
        RDQL_NodeValue x = this.left.evalRDQL(q, env);
        RDQL_NodeValue y = this.right.evalRDQL(q, env);
        boolean b = this.rawEval(x, y);
        NodeValueSettable result = x instanceof NodeValueSettable ? (NodeValueSettable)x : (y instanceof NodeValueSettable ? (NodeValueSettable)y : new WorkingVar());
        result.setBoolean(b);
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringLangEqual: Wrong number of children: " + n);
        }
        this.left = (ExprRDQL)((Object)this.jjtGetChild(0));
        this.right = (ExprRDQL)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return this.getClass().getName();
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.left instanceof Expression) {
            return (Expression)((Object)this.left);
        }
        if (i == 1 && this.right instanceof Expression) {
            return (Expression)((Object)this.right);
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString2(this.left, this.right, printName, opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.left, this.right, printName, opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }

    public void format(IndentedWriter writer) {
        RDQLQueryPrintUtils.format(writer, this.left, this.right, printName, opSymbol);
    }
}

