/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.junit.TestExpr;
import java.math.BigDecimal;

public class TestExprNumeric
extends TestExpr {
    boolean isDouble = false;
    Number rightAnswer;

    public TestExprNumeric(String exprStr, Number rightAnswer) {
        this(exprStr, rightAnswer, null, null);
    }

    public TestExprNumeric(String exprStr, Number rightAnswer, Query query2, Binding env) {
        this(exprStr, rightAnswer, query2, env, 100);
    }

    private TestExprNumeric(String exprStr, Number rightAnswer, Query query2, Binding env, int failureMode) {
        super("Numeric test : " + exprStr + " ", exprStr, query2, env, failureMode);
        this.rightAnswer = rightAnswer;
    }

    public TestExprNumeric(String exprStr, long rightAnswer) {
        this(exprStr, new Long(rightAnswer));
    }

    public TestExprNumeric(String exprStr, BigDecimal rightAnswer) {
        this(exprStr, (Number)rightAnswer);
    }

    public TestExprNumeric(String exprStr, double rightAnswer) {
        this(exprStr, new Double(rightAnswer));
    }

    public TestExprNumeric(String exprStr, long rightAnswer, Query query2, Binding env) {
        this(exprStr, new Long(rightAnswer), query2, env);
    }

    public TestExprNumeric(String exprStr, BigDecimal rightAnswer, Query query2, Binding env) {
        this(exprStr, (Number)rightAnswer, query2, env);
    }

    public TestExprNumeric(String exprStr, double rightAnswer, Query query2, Binding env) {
        this(exprStr, new Double(rightAnswer), query2, env);
    }

    void checkExpr(Expr expr) {
    }

    void checkValue(Expr expr, NodeValue nodeValue) {
        if (!this.evalCorrect()) {
            TestExprNumeric.fail(this.exprString + " => " + expr + " :: Expected eval exception but got: " + nodeValue);
        }
        if (!nodeValue.isNumber()) {
            TestExprNumeric.fail(this.exprString + ": Not a number for numeric expression: " + nodeValue);
        }
        if (this.rightAnswer instanceof Long) {
            if (!nodeValue.isInteger()) {
                TestExprNumeric.fail("Right answer is an integer: " + this.rightAnswer + ": got " + nodeValue);
            }
            TestExprNumeric.assertEquals("Parse " + this.exprString + " ==> " + expr + " ", (Long)this.rightAnswer, nodeValue.getInteger().longValue());
            return;
        }
        if (this.rightAnswer instanceof BigDecimal) {
            if (!nodeValue.isDecimal()) {
                TestExprNumeric.fail("Rigth answer is a decimal: " + this.rightAnswer + ": got " + nodeValue);
            }
            TestExprNumeric.assertEquals("Parse " + this.exprString + " ==> " + expr + " ", this.rightAnswer, nodeValue.getDecimal());
            return;
        }
        if (this.rightAnswer instanceof Double) {
            if (!nodeValue.isDouble()) {
                TestExprNumeric.fail("Rigth answer is a double: " + this.rightAnswer + ": got " + nodeValue);
            }
            TestExprNumeric.assertEquals("Parse " + this.exprString + " ==> " + expr + " ", (Double)this.rightAnswer, nodeValue.getDouble(), 1.0E-6);
            return;
        }
        TestExprNumeric.fail(this.exprString + ": Unrecognized kind of NodeValue for numeric expression: " + nodeValue);
    }

    void checkException(Expr expr, Exception ex) {
        if (!this.failureCorrect()) {
            TestExprNumeric.fail(this.exprString + " => " + expr + " :: Exception: " + ex);
        }
    }
}

