/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.library;

import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.serializer.FmtExprARQSubst;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.FileUtils;
import java.io.PrintStream;
import java.io.PrintWriter;

public class trace
implements Function {
    private static PrintWriter out = FileUtils.asPrintWriterUTF8(System.out);

    public static void setStream(PrintStream stream) {
        out = FileUtils.asPrintWriterUTF8(stream);
    }

    public void build(String uri, ExprList args) {
        if (args.size() != 1) {
            throw new QueryBuildException("Function '" + Utils.className(this) + "' takes one argument");
        }
    }

    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        if (args == null) {
            throw new ARQInternalErrorException("Function '" + Utils.className(this) + " Null args list");
        }
        if (args.size() != 1) {
            throw new ExprEvalException("Function '" + Utils.className(this) + " Wanted 1, got " + args.size());
        }
        Expr expr = args.get(0);
        String s = FmtExprARQSubst.format(expr, binding);
        try {
            NodeValue x = expr.eval(binding, env);
            out.println(s + " => " + x);
            out.flush();
        }
        catch (ExprEvalException ex) {
            out.println(s + " => Exception(" + ex.getMessage() + ")");
        }
        out.flush();
        return NodeValue.booleanReturn(true);
    }
}

