/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.commons.logging.LogFactory;

public class Functions {
    private static final int DIVIDE_PRECISION = 24;
    private static final BigDecimal BigDecimalZero = new BigDecimal(0.0);
    private static final int OP_INTEGER = 10;
    private static final int OP_DECIMAL = 20;
    private static final int OP_DOUBLE = 30;
    private static final int OP_FLOAT = 40;

    public static NodeValue add(NodeValue nv1, NodeValue nv2) {
        switch (Functions.classifyNumeric("add", nv1, nv2)) {
            case 10: {
                return NodeValue.makeInteger(nv1.getInteger().add(nv2.getInteger()));
            }
            case 20: {
                return NodeValue.makeDecimal(nv1.getDecimal().add(nv2.getDecimal()));
            }
            case 40: {
                return NodeValue.makeFloat(nv1.getFloat() + nv2.getFloat());
            }
            case 30: {
                return NodeValue.makeDouble(nv1.getDouble() + nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue subtract(NodeValue nv1, NodeValue nv2) {
        switch (Functions.classifyNumeric("subtract", nv1, nv2)) {
            case 10: {
                return NodeValue.makeInteger(nv1.getInteger().subtract(nv2.getInteger()));
            }
            case 20: {
                return NodeValue.makeDecimal(nv1.getDecimal().subtract(nv2.getDecimal()));
            }
            case 40: {
                return NodeValue.makeFloat(nv1.getFloat() - nv2.getFloat());
            }
            case 30: {
                return NodeValue.makeDouble(nv1.getDouble() - nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue multiply(NodeValue nv1, NodeValue nv2) {
        switch (Functions.classifyNumeric("multiply", nv1, nv2)) {
            case 10: {
                return NodeValue.makeInteger(nv1.getInteger().multiply(nv2.getInteger()));
            }
            case 20: {
                return NodeValue.makeDecimal(nv1.getDecimal().multiply(nv2.getDecimal()));
            }
            case 40: {
                return NodeValue.makeFloat(nv1.getFloat() * nv2.getFloat());
            }
            case 30: {
                return NodeValue.makeDouble(nv1.getDouble() * nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue divide(NodeValue nv1, NodeValue nv2) {
        switch (Functions.classifyNumeric("divide", nv1, nv2)) {
            case 10: {
                if (nv2.getInteger().equals(BigInteger.ZERO)) {
                    throw new ExprEvalException("Divide by zero in divide");
                }
                BigDecimal d1 = new BigDecimal(nv1.getInteger());
                BigDecimal d2 = new BigDecimal(nv2.getInteger());
                return NodeValue.makeDecimal(Functions.decimalDivide(d1, d2));
            }
            case 20: {
                if (nv2.getDecimal().equals(BigDecimalZero)) {
                    throw new ExprEvalException("Divide by zero in decimal divide");
                }
                BigDecimal d1 = nv1.getDecimal();
                BigDecimal d2 = nv2.getDecimal();
                return NodeValue.makeDecimal(Functions.decimalDivide(d1, d2));
            }
            case 40: {
                return NodeValue.makeFloat(nv1.getFloat() / nv2.getFloat());
            }
            case 30: {
                return NodeValue.makeDouble(nv1.getDouble() / nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    private static BigDecimal decimalDivide(BigDecimal d1, BigDecimal d2) {
        try {
            return d1.divide(d2, 24, 3);
        }
        catch (ArithmeticException ex) {
            LogFactory.getLog(Functions.class).warn("ArithmeticException in decimal divide - attempting to treat as doubles");
            return new BigDecimal(d1.doubleValue() / d2.doubleValue());
        }
    }

    public static NodeValue max(NodeValue nv1, NodeValue nv2) {
        int x = Functions.compareNumeric(nv1, nv2);
        if (x == -1) {
            return nv2;
        }
        return nv1;
    }

    public static NodeValue min(NodeValue nv1, NodeValue nv2) {
        int x = Functions.compareNumeric(nv1, nv2);
        if (x == 1) {
            return nv2;
        }
        return nv1;
    }

    public static NodeValue not(NodeValue nv) {
        boolean b = Functions.booleanEffectiveValue(nv);
        return NodeValue.booleanReturn(!b);
    }

    public static NodeValue booleanEffectiveValueAsNodeValue(NodeValue nv) {
        if (nv.isBoolean()) {
            return nv;
        }
        return NodeValue.booleanReturn(Functions.booleanEffectiveValue(nv));
    }

    public static boolean booleanEffectiveValue(NodeValue nv) {
        if (nv.isBoolean()) {
            return nv.getBoolean();
        }
        if (nv.isString()) {
            return nv.getString().length() > 0;
        }
        if (nv.isInteger()) {
            return !nv.getInteger().equals(NodeValue.IntegerZERO);
        }
        if (nv.isDecimal()) {
            return !nv.getDecimal().equals(NodeValue.DecimalZERO);
        }
        if (nv.isDouble()) {
            return nv.getDouble() != 0.0;
        }
        NodeValue.raise(new ExprEvalException("Not a boolean effective value (wrong type): " + nv));
        return false;
    }

    public static NodeValue unaryMinus(NodeValue nv) {
        switch (Functions.classifyNumeric("unaryMinus", nv)) {
            case 10: {
                return NodeValue.makeInteger(nv.getInteger().negate());
            }
            case 20: {
                return NodeValue.makeDecimal(nv.getDecimal().negate());
            }
            case 40: {
                return NodeValue.makeFloat(-nv.getFloat());
            }
            case 30: {
                return NodeValue.makeDouble(-nv.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + nv);
    }

    public static NodeValue unaryPlus(NodeValue nv) {
        int opType = Functions.classifyNumeric("unaryPlus", nv);
        return nv;
    }

    public static NodeValue abs(NodeValue nv) {
        switch (Functions.classifyNumeric("abs", nv)) {
            case 10: {
                return NodeValue.makeInteger(nv.getInteger().abs());
            }
            case 20: {
                return NodeValue.makeDecimal(nv.getDecimal().abs());
            }
            case 40: {
                return NodeValue.makeFloat(Math.abs(nv.getFloat()));
            }
            case 30: {
                return NodeValue.makeDouble(Math.abs(nv.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + nv);
    }

    public static NodeValue ceiling(NodeValue v) {
        switch (Functions.classifyNumeric("ceiling", v)) {
            case 10: {
                return v;
            }
            case 20: {
                BigDecimal dec = v.getDecimal().setScale(0, 2);
                return NodeValue.makeDecimal(dec);
            }
            case 40: {
                return NodeValue.makeDouble(Math.ceil(v.getFloat()));
            }
            case 30: {
                return NodeValue.makeDouble(Math.ceil(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue floor(NodeValue v) {
        switch (Functions.classifyNumeric("floor", v)) {
            case 10: {
                return v;
            }
            case 20: {
                BigDecimal dec = v.getDecimal().setScale(0, 3);
                return NodeValue.makeDecimal(dec);
            }
            case 40: {
                return NodeValue.makeDouble(Math.floor(v.getFloat()));
            }
            case 30: {
                return NodeValue.makeDouble(Math.floor(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue round(NodeValue v) {
        switch (Functions.classifyNumeric("round", v)) {
            case 10: {
                return v;
            }
            case 20: {
                BigDecimal dec = v.getDecimal().setScale(0, 1);
                return NodeValue.makeDecimal(dec);
            }
            case 40: {
                return NodeValue.makeFloat(Math.round(v.getFloat()));
            }
            case 30: {
                return NodeValue.makeDouble(Math.round(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue sqrt(NodeValue v) {
        switch (Functions.classifyNumeric("sqrt", v)) {
            case 10: {
                return v;
            }
            case 20: {
                double dec = v.getDecimal().doubleValue();
                return NodeValue.makeDecimal(Math.sqrt(dec));
            }
            case 40: {
                return NodeValue.makeDouble(Math.sqrt(v.getDouble()));
            }
            case 30: {
                return NodeValue.makeDouble(Math.sqrt(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue stringLength(NodeValue str2) {
        return NodeValue.makeInteger(str2.getString().length());
    }

    public static NodeValue javaSubstring(NodeValue v1, NodeValue v2) {
        return Functions.javaSubstring(v1, v2, null);
    }

    public static NodeValue javaSubstring(NodeValue nvString, NodeValue nvStart, NodeValue nvFinish) {
        try {
            String string = nvString.getString();
            int start = nvStart.getInteger().intValue();
            if (nvFinish == null) {
                return NodeValue.makeString(string.substring(start));
            }
            int finish = nvFinish.getInteger().intValue();
            return NodeValue.makeString(string.substring(start, finish));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    public static NodeValue substring(NodeValue v1, NodeValue v2) {
        return Functions.substring(v1, v2, null);
    }

    public static NodeValue substring(NodeValue nvString, NodeValue nvStart, NodeValue nvLength) {
        try {
            String string = nvString.getString();
            int start = Functions.intValueStr(nvStart);
            if (start <= 0) {
                start = 1;
            }
            --start;
            if (nvLength == null) {
                return NodeValue.makeString(string.substring(start));
            }
            int length = Functions.intValueStr(nvLength);
            int finish = start + length;
            if (finish > string.length()) {
                finish = string.length();
            }
            if (finish < 0) {
                finish = 0;
            }
            return NodeValue.makeString(string.substring(start, finish));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    private static int intValueStr(NodeValue nv) {
        if (nv.isInteger()) {
            return nv.getInteger().intValue();
        }
        if (nv.isDecimal()) {
            return (int)Math.round(nv.getDecimal().doubleValue());
        }
        if (nv.isFloat()) {
            return Math.round(nv.getFloat());
        }
        if (nv.isDouble()) {
            return (int)Math.round(nv.getDouble());
        }
        throw new ExprEvalException("Not a number:" + nv);
    }

    public static NodeValue strContains(NodeValue string, NodeValue match) {
        Functions.strCheck(string, match);
        boolean x = StringUtils.contains(string.getString(), match.getString());
        return NodeValue.booleanReturn(x);
    }

    public static NodeValue strStartsWith(NodeValue string, NodeValue match) {
        Functions.strCheck(string, match);
        return NodeValue.booleanReturn(string.getString().startsWith(match.getString()));
    }

    public static NodeValue strEndsWith(NodeValue string, NodeValue match) {
        Functions.strCheck(string, match);
        return NodeValue.booleanReturn(string.getString().endsWith(match.getString()));
    }

    public static NodeValue strLowerCase(NodeValue string) {
        Functions.strCheck(string);
        return NodeValue.makeString(string.getString().toLowerCase());
    }

    public static NodeValue strUpperCase(NodeValue string) {
        Functions.strCheck(string);
        return NodeValue.makeString(string.getString().toUpperCase());
    }

    private static void strCheck(NodeValue str2) {
        if (!str2.isString()) {
            throw new ExprEvalException("Not a string: " + str2);
        }
    }

    private static void strCheck(NodeValue str1, NodeValue str2) {
        if (!str1.isString()) {
            throw new ExprEvalException("Not a string (first arg): " + str1);
        }
        if (!str2.isString()) {
            throw new ExprEvalException("Not a string (second arg): " + str2);
        }
    }

    public static int classifyNumeric(String fName, NodeValue nv1, NodeValue nv2) {
        if (!nv1.isNumber()) {
            throw new ExprEvalException("Not a number (first arg to " + fName + "): " + nv1);
        }
        if (!nv2.isNumber()) {
            throw new ExprEvalException("Not a number (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isInteger()) {
            if (nv2.isInteger()) {
                return 10;
            }
            if (nv2.isDecimal()) {
                return 20;
            }
            if (nv2.isFloat()) {
                return 40;
            }
            if (nv2.isDouble()) {
                return 30;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isDecimal()) {
            if (nv2.isDecimal()) {
                return 20;
            }
            if (nv2.isFloat()) {
                return 40;
            }
            if (nv2.isDouble()) {
                return 30;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isFloat()) {
            if (nv2.isFloat()) {
                return 40;
            }
            if (nv2.isDouble()) {
                return 30;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isDouble()) {
            if (nv2.isDouble()) {
                return 30;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        throw new ARQInternalErrorException("Numeric op unrecognized (first arg to " + fName + "): " + nv1);
    }

    public static int classifyNumeric(String fName, NodeValue nv) {
        if (!nv.isNumber()) {
            throw new ExprEvalException("Not a number: (" + fName + ") " + nv);
        }
        if (nv.isInteger()) {
            return 10;
        }
        if (nv.isDecimal()) {
            return 20;
        }
        if (nv.isFloat()) {
            return 40;
        }
        if (nv.isDouble()) {
            return 30;
        }
        throw new ARQInternalErrorException("Numeric op unrecognized (" + fName + "): " + nv);
    }

    private static int calcReturn(int x) {
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    public static int compareNumeric(NodeValue nv1, NodeValue nv2) {
        int opType = Functions.classifyNumeric("compareNumeric", nv1, nv2);
        switch (opType) {
            case 10: {
                return Functions.calcReturn(nv1.getInteger().compareTo(nv2.getInteger()));
            }
            case 20: {
                return Functions.calcReturn(nv1.getDecimal().compareTo(nv2.getDecimal()));
            }
            case 40: {
                return Functions.calcReturn(Float.compare(nv1.getFloat(), nv2.getFloat()));
            }
            case 30: {
                return Functions.calcReturn(Double.compare(nv1.getDouble(), nv2.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static int compareString(NodeValue nv1, NodeValue nv2) {
        return Functions.calcReturn(nv1.getString().compareTo(nv2.getString()));
    }

    public static int compareDateTime(NodeValue nv1, NodeValue nv2) {
        return Functions.compareCal(nv1.getDateTime(), nv2.getDateTime());
    }

    public static int compareDate(NodeValue nv1, NodeValue nv2) {
        return Functions.compareCal(nv1.getDate(), nv2.getDate());
    }

    private static int compareCal(Calendar cal1, Calendar cal2) {
        if (cal1.after(cal2)) {
            return 1;
        }
        if (cal1.before(cal2)) {
            return -1;
        }
        return 0;
    }

    public static int compareBoolean(NodeValue nv1, NodeValue nv2) {
        boolean b2;
        boolean b1 = nv1.getBoolean();
        if (b1 == (b2 = nv2.getBoolean())) {
            return 0;
        }
        if (!b1 && b2) {
            return -1;
        }
        if (b1 && !b2) {
            return 1;
        }
        throw new ARQInternalErrorException("Weird boolean comparison: " + nv1 + ", " + nv2);
    }
}

