/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecUtils;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDiff;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDistinct;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterReduced;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSlice;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSort;
import com.hp.hpl.jena.sparql.engine.main.CompilerDispatch;
import com.hp.hpl.jena.sparql.engine.main.FilterPlacement;
import com.hp.hpl.jena.sparql.engine.main.JoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.LeftJoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.OpExtMain;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterGraph;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterJoin;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterLeftJoin;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterOptionalIndex;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterUnion;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprBuild;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprWalker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OpCompiler {
    private ExecutionContext execCxt;
    private CompilerDispatch dispatcher = null;
    private FilterPlacement filterPlacement;

    public static QueryIterator compile(Op op, ExecutionContext execCxt) {
        return OpCompiler.compile(op, OpCompiler.root(execCxt), execCxt);
    }

    public static QueryIterator compile(Op op, QueryIterator qIter, ExecutionContext execCxt) {
        OpCompiler compiler = new OpCompiler(execCxt);
        QueryIterator q = compiler.compileOp(op, qIter);
        return q;
    }

    private OpCompiler(ExecutionContext execCxt) {
        this.execCxt = execCxt;
        this.dispatcher = new CompilerDispatch(this);
        this.filterPlacement = new FilterPlacement(this, execCxt);
    }

    QueryIterator compileOp(Op op) {
        return this.compileOp(op, null);
    }

    QueryIterator compileOp(Op op, QueryIterator input) {
        return this.dispatcher.compile(op, input);
    }

    QueryIterator compile(OpBGP opBGP, QueryIterator input) {
        BasicPattern pattern = opBGP.getPattern();
        return StageBuilder.compile(pattern, input, this.execCxt);
    }

    QueryIterator compile(OpQuadPattern quadPattern, QueryIterator input) {
        throw new ARQNotImplemented("compile/OpQuadPattern");
    }

    QueryIterator compile(OpJoin opJoin, QueryIterator input) {
        boolean canDoLinear = JoinClassifier.isLinear(opJoin);
        QueryIterator left = this.compileOp(opJoin.getLeft(), input);
        if (canDoLinear) {
            QueryIterator right = this.compileOp(opJoin.getRight(), left);
            return right;
        }
        QueryIterator right = this.compileOp(opJoin.getRight(), this.root());
        QueryIterJoin qIter = new QueryIterJoin(left, right, this.execCxt);
        return qIter;
    }

    QueryIterator compile(OpLeftJoin opLeftJoin, QueryIterator input) {
        ExprList exprs = opLeftJoin.getExprs();
        if (exprs != null) {
            exprs.prepareExprs(this.execCxt.getContext());
        }
        QueryIterator left = this.compileOp(opLeftJoin.getLeft(), input);
        boolean canDoLinear = LeftJoinClassifier.isLinear(opLeftJoin);
        if (canDoLinear) {
            QueryIterOptionalIndex qIter = new QueryIterOptionalIndex(left, opLeftJoin.getRight(), exprs, this.execCxt);
            return qIter;
        }
        QueryIterator right = this.compileOp(opLeftJoin.getRight(), this.root());
        QueryIterLeftJoin qIter = new QueryIterLeftJoin(left, right, exprs, this.execCxt);
        return qIter;
    }

    QueryIterator compile(OpDiff opDiff, QueryIterator input) {
        QueryIterator left = this.compileOp(opDiff.getLeft(), input);
        QueryIterator right = this.compileOp(opDiff.getRight(), this.root());
        return new QueryIterDiff(left, right, this.execCxt);
    }

    QueryIterator compile(OpUnion opUnion, QueryIterator input) {
        ArrayList<Op> x = new ArrayList<Op>();
        x.add(opUnion.getLeft());
        while (opUnion.getRight() instanceof OpUnion) {
            OpUnion opUnionNext = (OpUnion)opUnion.getRight();
            x.add(opUnionNext);
        }
        x.add(opUnion.getRight());
        QueryIterUnion cIter = new QueryIterUnion(input, x, this.execCxt);
        return cIter;
    }

    QueryIterator compile(OpFilter opFilter, QueryIterator input) {
        ExprList exprs = opFilter.getExprs();
        exprs.prepareExprs(this.execCxt.getContext());
        Op base = opFilter.getSubOp();
        if (base instanceof OpBGP) {
            return this.filterPlacement.placeFiltersBGP(exprs, ((OpBGP)base).getPattern(), input);
        }
        if (base instanceof OpGraph) {
            // empty if block
        }
        if (base instanceof OpJoin) {
            ArrayList joinElts = new ArrayList();
            OpCompiler.joins(base, joinElts);
            return this.filterPlacement.placeFiltersJoin(exprs, joinElts, input);
        }
        if (base instanceof OpLeftJoin) {
            // empty if block
        }
        if (base instanceof OpUnion) {
            // empty if block
        }
        return this.filterPlacement.buildOpFilter(exprs, base, input);
    }

    private void prepareExprs(ExprList exprs) {
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            ExprWalker.walk(new ExprBuild(this.execCxt.getContext()), expr);
        }
    }

    private static void joins(Op base, List joinElts) {
        while (base instanceof OpJoin) {
            OpJoin join = (OpJoin)base;
            Op right = join.getRight();
            OpCompiler.joins(right, joinElts);
            base = join.getLeft();
        }
        joinElts.add(base);
    }

    QueryIterator compile(OpGraph opGraph, QueryIterator input) {
        return new QueryIterGraph(input, opGraph, this.execCxt);
    }

    QueryIterator compile(OpDatasetNames dsNames, QueryIterator input) {
        throw new ARQNotImplemented("OpDatasetNames");
    }

    QueryIterator compile(OpTable opTable, QueryIterator input) {
        if (opTable.isJoinIdentity()) {
            return input;
        }
        if (input instanceof QueryIterRoot) {
            input.close();
            return opTable.getTable().iterator(this.execCxt);
        }
        QueryIterator qIterT = opTable.getTable().iterator(this.execCxt);
        QueryIterJoin qIter = new QueryIterJoin(input, qIterT, this.execCxt);
        return qIter;
    }

    QueryIterator compile(OpExt opExt, QueryIterator input) {
        if (opExt instanceof OpExtMain) {
            OpExtMain op = (OpExtMain)opExt;
            return op.eval(input, this.execCxt);
        }
        throw new QueryExecException("Encountered unsupport OpExt: " + opExt.getName());
    }

    public QueryIterator compile(OpNull opNull, QueryIterator input) {
        return new QueryIterNullIterator(this.execCxt);
    }

    QueryIterator compile(OpList opList, QueryIterator input) {
        return this.compileOp(opList.getSubOp(), input);
    }

    QueryIterator compile(OpOrder opOrder, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opOrder.getSubOp(), input);
        qIter = new QueryIterSort(qIter, opOrder.getConditions(), this.execCxt);
        return qIter;
    }

    QueryIterator compile(OpProject opProject, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opProject.getSubOp(), input);
        qIter = new QueryIterProject(qIter, opProject.getVars(), this.execCxt);
        return qIter;
    }

    QueryIterator compile(OpSlice opSlice, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opSlice.getSubOp(), input);
        qIter = new QueryIterSlice(qIter, opSlice.getStart(), opSlice.getLength(), this.execCxt);
        return qIter;
    }

    QueryIterator compile(OpDistinct opDistinct, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opDistinct.getSubOp(), input);
        qIter = new QueryIterDistinct(qIter, this.execCxt);
        return qIter;
    }

    QueryIterator compile(OpReduced opReduced, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opReduced.getSubOp(), input);
        qIter = new QueryIterReduced(qIter, this.execCxt);
        return qIter;
    }

    static QueryIterator root(ExecutionContext execCxt) {
        return ExecUtils.makeRoot(execCxt);
    }

    private QueryIterator root() {
        return OpCompiler.root(this.execCxt);
    }
}

