/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIteratorLogging
extends QueryIteratorWrapper {
    private Log log = null;
    private boolean logging = true;

    public QueryIteratorLogging(QueryIterator input) {
        super(input);
        this.log = LogFactory.getLog(input.getClass());
    }

    protected boolean hasNextBinding() {
        boolean b = super.hasNextBinding();
        if (this.logging) {
            this.log.info("hasNextBinding: " + b);
        }
        return b;
    }

    protected Binding moveToNextBinding() {
        Binding binding = super.moveToNextBinding();
        if (this.logging) {
            this.log.info("moveToNextBinding: " + binding);
        }
        return binding;
    }

    protected void closeIterator() {
        if (this.logging) {
            this.log.info("closeIterator:");
        }
        super.closeIterator();
    }

    public void loggingOn() {
        this.logging(true);
    }

    public void loggingOff() {
        this.logging(false);
    }

    public void logging(boolean state) {
        this.logging = state;
    }
}

