/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConvert;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Collection;

public class QueryIterProject
extends QueryIterConvert {
    Collection projectionVars;

    public QueryIterProject(QueryIterator input, Collection vars, ExecutionContext qCxt) {
        super(input, new Projection(vars), qCxt);
        Var.checkVarList(vars);
        this.projectionVars = vars;
    }

    public Collection getProjectionVars() {
        return this.projectionVars;
    }

    protected void releaseResources() {
    }

    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Utils.className(this));
        out.print(" ");
        PrintUtils.printList(out, this.projectionVars);
    }

    static class Projection
    implements QueryIterConvert.Converter {
        Collection projectionVars;

        Projection(Collection vars) {
            this.projectionVars = vars;
        }

        public Binding convert(Binding bind) {
            BindingProject bind2 = new BindingProject(this.projectionVars, bind);
            return bind2;
        }
    }
}

