/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import com.hp.hpl.jena.sparql.util.Convert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpQuery
extends Params {
    static final Log log = LogFactory.getLog(HttpQuery.class.getName());
    public static int urlLimit = 2048;
    String serviceURL;
    String contentTypeResult = "application/sparql-results+xml";
    HttpURLConnection httpConnection = null;
    static final Object noValue = new Object();
    int responseCode = 0;
    String responseMessage = null;
    boolean forcePOST = false;
    String queryString = null;
    static final String ENC_UTF8 = "UTF-8";

    public HttpQuery(String serviceURL) {
        this.init(serviceURL);
    }

    public HttpQuery(URL url) {
        this.init(url.toString());
    }

    private void init(String serviceURL) {
        if (log.isTraceEnabled()) {
            log.trace("URL: " + serviceURL);
        }
        if (serviceURL.indexOf(63) >= 0) {
            throw new QueryExceptionHTTP(-1, "URL already has a query string (" + serviceURL + ")");
        }
        this.serviceURL = serviceURL;
    }

    private String getQueryString() {
        if (this.queryString == null) {
            this.queryString = super.httpString();
        }
        return this.queryString;
    }

    public HttpURLConnection getConnection() {
        return this.httpConnection;
    }

    public void setAccept(String contentType) {
        this.contentTypeResult = contentType;
    }

    public boolean usesPOST() {
        if (this.forcePOST) {
            return true;
        }
        String s = this.getQueryString();
        return this.serviceURL.length() + s.length() >= urlLimit;
    }

    public void setForcePOST() {
        this.forcePOST = true;
    }

    public InputStream exec() throws QueryExceptionHTTP {
        try {
            if (this.usesPOST()) {
                return this.execPost();
            }
            return this.execGet();
        }
        catch (QueryExceptionHTTP httpEx) {
            log.trace("Exception in exec", httpEx);
            throw httpEx;
        }
        catch (JenaException jEx) {
            log.trace("JenaException in exec", jEx);
            throw jEx;
        }
    }

    private InputStream execGet() throws QueryExceptionHTTP {
        URL target = null;
        String qs = this.getQueryString();
        try {
            target = this.count() == 0 ? new URL(this.serviceURL) : new URL(this.serviceURL + "?" + qs);
        }
        catch (MalformedURLException malEx) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malEx);
        }
        log.trace("GET " + target.toExternalForm());
        try {
            this.httpConnection = (HttpURLConnection)target.openConnection();
            this.httpConnection.setRequestProperty("Accept", this.contentTypeResult);
            this.httpConnection.setDoInput(true);
            this.httpConnection.connect();
            try {
                return this.execCommon();
            }
            catch (QueryExceptionHTTP qEx) {
                if (qEx.getResponseCode() == 414) {
                    return this.execPost();
                }
                throw qEx;
            }
        }
        catch (ConnectException connEx) {
            throw new QueryExceptionHTTP(-404, "Failed to connect to remote server");
        }
        catch (IOException ioEx) {
            throw new QueryExceptionHTTP(ioEx);
        }
    }

    private InputStream execPost() throws QueryExceptionHTTP {
        URL target = null;
        try {
            target = new URL(this.serviceURL);
        }
        catch (MalformedURLException malEx) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malEx);
        }
        log.trace("POST " + target.toExternalForm());
        try {
            this.httpConnection = (HttpURLConnection)target.openConnection();
            this.httpConnection.setRequestMethod("POST");
            this.httpConnection.setRequestProperty("Accept", this.contentTypeResult);
            this.httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.httpConnection.setDoOutput(true);
            OutputStream out = this.httpConnection.getOutputStream();
            ListIterator iter = this.pairs().listIterator();
            while (iter.hasNext()) {
                Params.Pair p = (Params.Pair)iter.next();
                out.write(p.getName().getBytes());
                out.write(61);
                String x = p.getValue();
                x = Convert.encWWWForm(x);
                out.write(x.getBytes());
                out.write(38);
            }
            out.flush();
            this.httpConnection.connect();
            return this.execCommon();
        }
        catch (JenaException rdfEx) {
            throw new QueryExceptionHTTP(-1, "Failed to create RDF request");
        }
        catch (ConnectException connEx) {
            throw new QueryExceptionHTTP(-1, "Failed to connect to remote server");
        }
        catch (IOException ioEx) {
            throw new QueryExceptionHTTP(ioEx);
        }
    }

    private InputStream execCommon() throws QueryExceptionHTTP {
        try {
            this.responseCode = this.httpConnection.getResponseCode();
            this.responseMessage = Convert.decWWWForm(this.httpConnection.getResponseMessage());
            if (300 <= this.responseCode && this.responseCode < 400) {
                throw new QueryExceptionHTTP(this.responseCode, this.responseMessage);
            }
            if (this.responseCode >= 400) {
                throw new QueryExceptionHTTP(this.responseCode, this.responseMessage);
            }
            InputStream in = this.httpConnection.getInputStream();
            return in;
        }
        catch (IOException ioEx) {
            throw new QueryExceptionHTTP(ioEx);
        }
        catch (JenaException rdfEx) {
            throw new QueryExceptionHTTP(rdfEx);
        }
    }

    public String toString() {
        String s = this.httpString();
        if (s != null || s.length() > 0) {
            return this.serviceURL + "?" + this.httpString();
        }
        return this.serviceURL;
    }
}

