/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.test;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import junit.framework.TestSuite;

public class TestPrefixMapping
extends AbstractTestPrefixMapping {
    public TestPrefixMapping(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPrefixMapping.class);
    }

    protected PrefixMapping getMapping() {
        return new PrefixMappingImpl();
    }

    public void testStandard() {
        this.testStandard(PrefixMapping.Standard);
    }

    public void testExtended() {
        this.testExtended(PrefixMapping.Extended);
    }

    public void testStandard(PrefixMapping st) {
        TestPrefixMapping.assertEquals(RDF.getURI(), st.getNsPrefixURI("rdf"));
        TestPrefixMapping.assertEquals(RDFS.getURI(), st.getNsPrefixURI("rdfs"));
        TestPrefixMapping.assertEquals(DC.getURI(), st.getNsPrefixURI("dc"));
        TestPrefixMapping.assertEquals(OWL.getURI(), st.getNsPrefixURI("owl"));
        TestPrefixMapping.assertEquals("http://www.daml.org/2001/03/daml+oil#", st.getNsPrefixURI("daml"));
    }

    public void testExtended(PrefixMapping st) {
        this.testStandard(st);
        TestPrefixMapping.assertEquals(RSS.getURI(), st.getNsPrefixURI("rss"));
        TestPrefixMapping.assertEquals(VCARD.getURI(), st.getNsPrefixURI("vcard"));
        TestPrefixMapping.assertEquals(JenaModelSpec.getURI(), st.getNsPrefixURI("jms"));
        TestPrefixMapping.assertEquals(JA.getURI(), st.getNsPrefixURI("ja"));
        TestPrefixMapping.assertEquals("http://www.example.org/", st.getNsPrefixURI("eg"));
    }
}

