/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.regression.Regression;
import junit.framework.TestSuite;

public class NewRegressionStatements
extends ModelTestBase {
    static final String subjURI = "http://aldabaran.hpl.hp.com/foo";
    static final String predURI = "http://aldabaran.hpl.hp.com/bar";
    protected Resource r;
    protected Property p;
    protected Model m;

    public NewRegressionStatements(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionStatements.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.r = this.m.createResource(subjURI);
        this.p = this.m.createProperty(predURI);
    }

    public void tearDown() {
        this.m = null;
        this.r = null;
        this.p = null;
    }

    public void testCreateStatementTrue() {
        Statement s = this.m.createStatement(this.r, this.p, true);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals(true, s.getBoolean());
    }

    public void testCreateStatementByteMax() {
        Statement s = this.m.createStatement(this.r, this.p, 127L);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals((byte)127, s.getByte());
    }

    public void testCreateStatementShortMax() {
        Statement s = this.m.createStatement(this.r, this.p, 32767L);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals((short)Short.MAX_VALUE, s.getShort());
    }

    public void testCreateStatementIntMax() {
        Statement s = this.m.createStatement(this.r, this.p, Integer.MAX_VALUE);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals(Integer.MAX_VALUE, s.getInt());
    }

    public void testCreateStatementLongMax() {
        Statement s = this.m.createStatement(this.r, this.p, Long.MAX_VALUE);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals(Long.MAX_VALUE, s.getLong());
    }

    public void testCreateStatementChar() {
        Statement s = this.m.createStatement(this.r, this.p, '$');
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals('$', s.getChar());
    }

    public void testCreateStatementFloat() {
        Statement s = this.m.createStatement(this.r, this.p, 123.456f);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals((double)123.456f, (double)s.getFloat(), 5.0E-4);
    }

    public void testCreateStatementDouble() {
        Statement s = this.m.createStatement(this.r, this.p, 12345.6789);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals(12345.6789, s.getDouble(), 5.0E-7);
    }

    public void testCreateStatementString() {
        String string = "this is a plain string";
        String lang = "en";
        Statement s = this.m.createStatement(this.r, this.p, string);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals(string, s.getString());
        NewRegressionStatements.assertEquals(lang, this.m.createStatement(this.r, this.p, string, lang).getLanguage());
    }

    public void testCreateStatementTypeLiteral() {
        Model m = ModelFactory.createDefaultModel();
        Resource R = m.createResource("http://example/r");
        Property P = m.createProperty("http://example/p");
        m.add(R, P, "2", XSDDatatype.XSDinteger);
        Literal L = ResourceFactory.createTypedLiteral("2", XSDDatatype.XSDinteger);
        NewRegressionStatements.assertTrue(m.contains(R, P, L));
        NewRegressionStatements.assertFalse(m.contains(R, P, "2"));
    }

    public void testCreateStatementFactory() {
        Regression.LitTestObj tv = new Regression.LitTestObj(Long.MIN_VALUE);
        Statement s = this.m.createStatement(this.r, this.p, tv);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals(tv, s.getObject(new Regression.LitTestObjF()));
    }

    public void testCreateStatementResource() {
        Resource tv = this.m.createResource();
        Statement s = this.m.createStatement(this.r, this.p, tv);
        NewRegressionStatements.assertEquals(this.r, s.getSubject());
        NewRegressionStatements.assertEquals(this.p, s.getPredicate());
        NewRegressionStatements.assertEquals(tv, s.getResource());
    }
}

