/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionResourceMethods
extends NewRegressionBase {
    protected Model m;
    protected Resource r;
    protected final String lang = "en";
    protected Literal tvLiteral;
    protected Resource tvResource;

    public NewRegressionResourceMethods(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionResourceMethods.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.tvLiteral = this.m.createLiteral("test 12 string 2");
        this.tvResource = this.m.createResource();
        this.r = this.m.createResource().addProperty(RDF.value, 1L).addProperty(RDF.value, 2L).addProperty(RDF.value, -1L).addProperty(RDF.value, -2L).addProperty(RDF.value, '!').addProperty(RDF.value, 123.456f).addProperty(RDF.value, -123.456).addProperty(RDF.value, "test 12 string").addProperty(RDF.value, "test 12 string", "en").addProperty(RDF.value, tvObject).addProperty(RDF.value, this.tvLiteral).addProperty(RDF.value, this.tvResource);
    }

    public void testByte() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, 1L));
    }

    public void testShort() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, 2L));
    }

    public void testInt() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, -1L));
    }

    public void testLong() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, -2L));
    }

    public void testChar() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, '!'));
    }

    public void testFloat() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, 123.456f));
    }

    public void testDouble() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, -123.456));
    }

    public void testString() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, "test 12 string"));
    }

    public void testStringWithLanguage() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, "test 12 string", "en"));
    }

    public void testObject() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, tvObject));
    }

    public void testLiteral() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, this.tvLiteral));
    }

    public void testResource() {
        NewRegressionResourceMethods.assertTrue(this.r.hasProperty(RDF.value, this.tvResource));
    }

    public void testCorrectSubject() {
        NewRegressionResourceMethods.assertEquals(this.r, this.r.getRequiredProperty(RDF.value).getSubject());
    }

    public void testNoSuchPropertyException() {
        try {
            this.r.getRequiredProperty(RDF.type);
            NewRegressionResourceMethods.fail("missing property should throw exception");
        }
        catch (PropertyNotFoundException e2) {
            NewRegressionResourceMethods.pass();
        }
    }

    public void testNoSuchPropertyNull() {
        NewRegressionResourceMethods.assertNull(this.r.getProperty(RDF.type));
    }

    public void testAllSubjectsCorrect() {
        this.testHasSubjectR(this.m.listStatements());
        this.testHasSubjectR(this.r.listProperties());
    }

    protected void testHasSubjectR(StmtIterator it) {
        while (it.hasNext()) {
            NewRegressionResourceMethods.assertEquals(this.r, it.nextStatement().getSubject());
        }
    }

    public void testCountsCorrect() {
        NewRegressionResourceMethods.assertEquals(12, NewRegressionResourceMethods.iteratorToList(this.m.listStatements()).size());
        NewRegressionResourceMethods.assertEquals(12, NewRegressionResourceMethods.iteratorToList(this.r.listProperties(RDF.value)).size());
        NewRegressionResourceMethods.assertEquals(0, NewRegressionResourceMethods.iteratorToList(this.r.listProperties(RDF.type)).size());
    }

    public void testRemoveProperties() {
        this.r.removeProperties();
        NewRegressionResourceMethods.assertEquals(false, this.m.listStatements(this.r, null, (RDFNode)null).hasNext());
    }
}

