/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionAddModel
extends ModelTestBase {
    protected Model m;

    public NewRegressionAddModel(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionAddModel.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
    }

    public void tearDown() {
        this.m = null;
    }

    public void testAddByIterator() {
        Model m1 = this.getModel();
        Model m2 = this.getModel();
        NewRegressionAddModel.modelAdd(m1, "a P b; c P d; x Q 1; y Q 2");
        m2.add(m1.listStatements());
        NewRegressionAddModel.assertEquals(m1.size(), m2.size());
        this.assertSameStatements(m1, m2);
        m1.add(m1.createResource(), RDF.value, m1.createResource());
        m1.add(m1.createResource(), RDF.value, m1.createResource());
        m1.add(m1.createResource(), RDF.value, m1.createResource());
        StmtIterator s = m1.listStatements();
        m2.remove(s.nextStatement()).remove(s);
        NewRegressionAddModel.assertEquals(0L, m2.size());
    }

    public void testAddByModel() {
        Model m1 = this.getModel();
        Model m2 = this.getModel();
        NewRegressionAddModel.modelAdd(m1, "a P b; c P d; x Q 1; y Q 2");
        m2.add(m1);
        NewRegressionAddModel.assertEquals(m1.size(), m2.size());
        this.assertSameStatements(m1, m2);
    }

    public void testRemoveByModel() {
        Model m1 = this.getModel();
        Model m2 = this.getModel();
        NewRegressionAddModel.modelAdd(m1, "a P b; c P d; x Q 1; y Q 2");
        m2.add(m1).remove(m1);
        NewRegressionAddModel.assertEquals(0L, m2.size());
        NewRegressionAddModel.assertFalse(m2.listStatements().hasNext());
    }

    protected void assertSameStatements(Model m1, Model m2) {
        this.assertContainsAll(m1, m2);
        this.assertContainsAll(m2, m1);
    }

    protected void assertContainsAll(Model m1, Model m2) {
        StmtIterator s = m2.listStatements();
        while (s.hasNext()) {
            NewRegressionAddModel.assertTrue(m1.contains(s.nextStatement()));
        }
    }
}

