/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.Trail;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTrail
extends TestCase {
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");

    public TestTrail(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTrail.class);
    }

    public void testUnify() {
        Node_RuleVariable X = new Node_RuleVariable("x", 0);
        Node_RuleVariable Y2 = new Node_RuleVariable("y", 1);
        Node_RuleVariable Z = new Node_RuleVariable("z", 2);
        Trail trail = new Trail();
        TestTrail.assertTrue(trail.unify(new TriplePattern(X, this.p, Y2), new TriplePattern(this.a, this.p, this.b)));
        TestTrail.assertEquals(X.deref(), this.a);
        TestTrail.assertEquals(Y2.deref(), this.b);
        TestTrail.assertTrue(Z.isUnbound());
        trail.unwindAndClear();
        TestTrail.assertTrue(X.isUnbound());
        TestTrail.assertTrue(Y2.isUnbound());
        TestTrail.assertTrue(trail.unify(new TriplePattern(X, this.p, X), new TriplePattern(Z, this.p, this.a)));
        TestTrail.assertEquals(X.deref(), this.a);
        TestTrail.assertEquals(Z.deref(), this.a);
        trail.unwindAndClear();
        TriplePattern gf = new TriplePattern(X, this.p, Functor.makeFunctorNode("f", new Node[]{X, this.b}));
        TriplePattern hf1 = new TriplePattern(Y2, this.p, Functor.makeFunctorNode("f", new Node[]{Z, this.b}));
        TriplePattern hf2 = new TriplePattern(Y2, this.p, Functor.makeFunctorNode("f", new Node[]{this.a, Y2}));
        TriplePattern hf3 = new TriplePattern(Y2, this.p, Functor.makeFunctorNode("f", new Node[]{this.b, Y2}));
        TestTrail.assertTrue(trail.unify(gf, hf1));
        TestTrail.assertEquals(X.deref(), Y2.deref());
        TestTrail.assertEquals(X.deref(), Z.deref());
        trail.unwindAndClear();
        TestTrail.assertTrue(!trail.unify(gf, hf2));
        TestTrail.assertTrue(X.isUnbound());
        TestTrail.assertTrue(Y2.isUnbound());
        TestTrail.assertTrue(Z.isUnbound());
        trail.unwindAndClear();
        TestTrail.assertTrue(trail.unify(gf, hf3));
        TestTrail.assertEquals(X.deref(), this.b);
        TestTrail.assertEquals(Y2.deref(), this.b);
        trail.unwindAndClear();
    }

    public void testMatching() {
        Node_RuleVariable X = new Node_RuleVariable("x", 0);
        Node_RuleVariable Y2 = new Node_RuleVariable("y", 1);
        Node_RuleVariable Z = new Node_RuleVariable("z", 2);
        Node_RuleVariable X1 = new Node_RuleVariable("x1", 0);
        Node_RuleVariable Y1 = new Node_RuleVariable("y1", 1);
        Node_RuleVariable Z1 = new Node_RuleVariable("z1", 2);
        TestTrail.assertTrue(X.sameValueAs(Y2));
        TriplePattern f1 = new TriplePattern(X, this.p, Functor.makeFunctorNode("f", new Node[]{X, this.b}));
        TriplePattern f2 = new TriplePattern(Y2, this.p, Functor.makeFunctorNode("f", new Node[]{Z, this.b}));
        TriplePattern f3 = new TriplePattern(Y1, this.p, Functor.makeFunctorNode("f", new Node[]{Y1, this.b}));
        TriplePattern f4 = new TriplePattern(X1, this.p, Functor.makeFunctorNode("f", new Node[]{Z1, this.b}));
        TestTrail.assertEquals(f1, f2);
        TestTrail.assertEquals(f1.hashCode(), f2.hashCode());
        TestTrail.assertTrue(f1.variantOf(f3));
        TestTrail.assertTrue(f2.variantOf(f4));
        TestTrail.assertTrue(!f1.variantOf(f2));
        TestTrail.assertTrue(!f3.variantOf(f4));
    }
}

