/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.DoesNotReifyException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Set;

public abstract class AbstractTestReifiedStatements
extends ModelTestBase {
    private Model model;
    private Resource S;
    private Property P;
    private RDFNode O;
    private Statement SPO;
    private Statement SPO2;
    private static final String aURI = "jena:test/reifying#someURI";
    private static final String anotherURI = "jena:test/reifying#anotherURI";
    private static final String anchor = "jena:test/Reifying#";
    protected static Set empty = CollectionFactory.createHashedSet();

    public AbstractTestReifiedStatements(String name) {
        super(name);
    }

    public abstract Model getModel();

    public void setUp() {
        this.model = this.getModel();
        Resource S2 = this.model.createResource("jena:test/Reifying#subject2");
        this.S = this.model.createResource("jena:test/Reifying#subject");
        this.P = this.model.createProperty("jena:test/Reifying#predicate");
        this.O = this.model.createLiteral("jena:test/Reifying#object");
        this.SPO = this.model.createStatement(this.S, this.P, this.O);
        this.SPO2 = this.model.createStatement(S2, this.P, this.O);
    }

    public void testBasicReification() {
        if (this.model.getReificationStyle() != ModelFactory.Minimal) {
            Resource R = this.model.createResource(aURI);
            this.model.add(R, RDF.type, RDF.Statement);
            this.model.add(R, RDF.subject, this.S);
            this.model.add(R, RDF.predicate, this.P);
            this.model.add(R, RDF.object, this.O);
            RDFNode rs = R.as(ReifiedStatement.class);
            AbstractTestReifiedStatements.assertEquals("can recover statement", this.SPO, ((ReifiedStatement)rs).getStatement());
        }
    }

    public void testReificationCombinations() {
        Resource RR = this.model.createResource(aURI);
        Resource SS = this.model.createResource(anotherURI);
        Property PP = (Property)RR.as(Property.class);
        Object[][] statements = new Object[][]{{this.model.createStatement(RR, RDF.type, RDF.Statement), new Integer(1)}, {this.model.createStatement(RR, RDF.subject, SS), new Integer(2)}, {this.model.createStatement(RR, RDF.predicate, PP), new Integer(4)}, {this.model.createStatement(RR, RDF.object, this.O), new Integer(8)}, {this.model.createStatement(SS, PP, this.O), new Integer(16)}, {this.model.createStatement(RR, PP, this.O), new Integer(32)}, {this.model.createStatement(SS, RDF.subject, SS), new Integer(64)}, {this.model.createStatement(SS, RDF.predicate, PP), new Integer(128)}, {this.model.createStatement(SS, RDF.object, this.O), new Integer(256)}, {this.model.createStatement(SS, RDF.type, RDF.Statement), new Integer(512)}};
        if (this.model.getReificationStyle() != ModelFactory.Minimal) {
            this.testCombinations(this.model, RR, 0, statements, statements.length);
        }
    }

    private void testCombinations(Model m, Resource R, int mask, Object[][] statements, int n) {
        if (n == 0) {
            try {
                ReifiedStatement rs = (ReifiedStatement)R.as(ReifiedStatement.class);
                AbstractTestReifiedStatements.assertTrue("should not reify: not all components present [" + mask + "]: " + rs, (mask & 0xF) == 15);
            }
            catch (DoesNotReifyException e2) {
                AbstractTestReifiedStatements.assertFalse("should reify: all components present", mask == 15);
            }
        } else {
            int i = n - 1;
            Statement s = (Statement)statements[i][0];
            int bits = (Integer)statements[i][1];
            this.testCombinations(m, R, mask, statements, i);
            m.add(s);
            this.testCombinations(m, R, mask + bits, statements, i);
            m.remove(s);
        }
    }

    public void testThisWillBreak() {
        Resource R = this.model.createResource(aURI);
        this.SPO.createReifiedStatement(aURI);
        this.model.add(R, RDF.subject, R);
    }

    public void testDirtyReification() {
        Resource R = this.model.createResource(aURI);
        this.model.add(R, RDF.type, RDF.Statement);
        this.model.add(R, RDF.subject, this.S);
        this.model.add(R, RDF.subject, this.P);
        this.testDoesNotReify("boo", R);
    }

    public void testDoesNotReify(String title, Resource r) {
        try {
            r.as(ReifiedStatement.class);
            AbstractTestReifiedStatements.fail(title + " (" + r + ")");
        }
        catch (DoesNotReifyException doesNotReifyException) {
            // empty catch block
        }
    }

    public void testConversion() {
        String uri = "spoo:handle";
        this.model.createReifiedStatement("spoo:handle", this.SPO);
        ReifiedStatement rs2 = (ReifiedStatement)this.model.createResource("spoo:handle").as(ReifiedStatement.class);
        AbstractTestReifiedStatements.assertEquals("recover statement", this.SPO, rs2.getStatement());
    }

    public void testDoesNotReifyUnknown() {
        this.testDoesNotReify("model should not reify rubbish", this.model.createResource("spoo:rubbish"));
    }

    public void testQuintetOfQuadlets() {
        Resource rs = this.model.createResource();
        rs.addProperty(RDF.type, RDF.Statement);
        this.model.createResource().addProperty(RDF.value, rs);
        rs.addProperty(RDF.subject, this.model.createResource());
        rs.addProperty(RDF.predicate, this.model.createProperty("http://example.org/foo"));
        rs.addProperty(RDF.object, this.model.createResource());
        rs.addProperty(RDF.object, this.model.createResource());
        StmtIterator it = this.model.listStatements();
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            AbstractTestReifiedStatements.assertFalse(s.getObject().equals(s.getSubject()));
        }
    }

    public void testConstructionByURI() {
        ReifiedStatement rs = this.model.createReifiedStatement("spoo:handle", this.SPO);
        ReifiedStatement rs2 = this.SPO.createReifiedStatement("spoo:gripper");
        AbstractTestReifiedStatements.assertEquals("recover statement (URI)", this.SPO, rs.getStatement());
        AbstractTestReifiedStatements.assertEquals("recover URI", "spoo:handle", rs.getURI());
        AbstractTestReifiedStatements.assertEquals("recover URI", "spoo:gripper", rs2.getURI());
    }

    public void testStatementAndModel(String title, ReifiedStatement rs, Model m, Statement st) {
        AbstractTestReifiedStatements.assertEquals(title + ": recover statement", st, rs.getStatement());
        AbstractTestReifiedStatements.assertEquals(title + ": recover model", m, rs.getModel());
    }

    public void testConstructionFromStatements() {
        this.testStatementAndModel("fromStatement", this.SPO.createReifiedStatement(), this.model, this.SPO);
    }

    public void testConstructionFromModels() {
        this.testStatementAndModel("fromModel", this.model.createReifiedStatement(this.SPO), this.model, this.SPO);
    }

    public Set getSetRS(Model m) {
        return GraphTestBase.iteratorToSet(m.listReifiedStatements());
    }

    public void testListReifiedStatements() {
        AbstractTestReifiedStatements.assertEquals("initially: no reified statements", empty, this.getSetRS(this.model));
        ReifiedStatement rs = this.model.createReifiedStatement(aURI, this.SPO);
        this.model.add((Resource)rs, this.P, this.O);
        Set justRS = this.arrayToSet(new Object[]{rs});
        AbstractTestReifiedStatements.assertEquals("post-add: one reified statement", justRS, this.getSetRS(this.model));
        this.model.add(this.S, this.P, rs);
        AbstractTestReifiedStatements.assertEquals("post-add: still one reified statement", justRS, this.getSetRS(this.model));
        ReifiedStatement rs2 = this.model.createReifiedStatement(anotherURI, this.SPO2);
        Set bothRS = this.arrayToSet(new Object[]{rs, rs2});
        this.model.add((Resource)rs2, this.P, this.O);
        AbstractTestReifiedStatements.assertEquals("post-add: still one reified statement", bothRS, this.getSetRS(this.model));
    }

    public void testListDoesntCrash() {
        this.model.createReifiedStatement(this.SPO);
        this.model.createReifiedStatement(this.SPO2);
        AbstractTestReifiedStatements.assertTrue("should be non-empty", this.model.listReifiedStatements().hasNext());
    }

    public Set getSetRS(Model m, Statement st) {
        return GraphTestBase.iteratorToSet(m.listReifiedStatements(st));
    }

    public void testListReifiedSpecificStatements() {
        AbstractTestReifiedStatements.assertEquals("no statements should match st", empty, this.getSetRS(this.model, this.SPO));
        ReifiedStatement rs = this.model.createReifiedStatement(aURI, this.SPO);
        ReifiedStatement rs2 = this.model.createReifiedStatement(anotherURI, this.SPO2);
        this.model.add((Resource)rs, this.P, this.O);
        Set justRS2 = this.arrayToSet(new Object[]{rs2});
        this.model.add((Resource)rs2, this.P, this.O);
        AbstractTestReifiedStatements.assertEquals("now one matching statement", justRS2, this.getSetRS(this.model, this.SPO2));
    }

    public void testStatementListReifiedStatements() {
        Statement st = this.SPO;
        Model m = this.model;
        AbstractTestReifiedStatements.assertEquals("it's not there yet", empty, GraphTestBase.iteratorToSet(st.listReifiedStatements()));
        ReifiedStatement rs = m.createReifiedStatement(aURI, st);
        Set justRS = this.arrayToSet(new Object[]{rs});
        m.add((Resource)rs, this.P, this.O);
        AbstractTestReifiedStatements.assertEquals("it's here now", justRS, GraphTestBase.iteratorToSet(st.listReifiedStatements()));
    }

    public void testIsReified() {
        ReifiedStatement rs = this.model.createReifiedStatement(aURI, this.SPO);
        Resource BS = this.model.createResource("jena:test/Reifying#BS");
        Property BP = this.model.createProperty("jena:test/Reifying#BP");
        Property BO = this.model.createProperty("jena:test/Reifying#BO");
        this.model.add((Resource)rs, this.P, this.O);
        AbstractTestReifiedStatements.assertTrue("st should be reified now", this.SPO.isReified());
        AbstractTestReifiedStatements.assertTrue("m should have st reified now", this.model.isReified(this.SPO));
        AbstractTestReifiedStatements.assertFalse("this new statement should not be reified", this.model.createStatement(BS, BP, BO).isReified());
    }

    public void testGetAny() {
        Resource r = this.model.getAnyReifiedStatement(this.SPO);
        AbstractTestReifiedStatements.assertInstanceOf(ReifiedStatement.class, r);
        AbstractTestReifiedStatements.assertEquals("should get me the statement", this.SPO, ((ReifiedStatement)r).getStatement());
    }

    public void testRemoveReificationWorks() {
        Statement st = this.SPO;
        Model m = this.model;
        m.createReifiedStatement(aURI, st);
        AbstractTestReifiedStatements.assertTrue("st is now reified", st.isReified());
        m.removeAllReifications(st);
        AbstractTestReifiedStatements.assertFalse("st is no longer reified", st.isReified());
    }

    public void testLeosBug() {
        Model A = this.getModel();
        Statement st = AbstractTestReifiedStatements.statement(A, "pigs fly south");
        ReifiedStatement rst = st.createReifiedStatement("eh:pointer");
        A.removeReification(rst);
        AbstractTestReifiedStatements.assertIsoModels(ModelFactory.createDefaultModel(), A);
    }

    public void testRR() {
        Statement st = this.SPO;
        Model m = this.model;
        ReifiedStatement rs1 = m.createReifiedStatement(aURI, st);
        ReifiedStatement rs2 = m.createReifiedStatement(anotherURI, st);
        m.removeReification(rs1);
        this.testNotReifying(m, aURI);
        AbstractTestReifiedStatements.assertTrue("st is still reified", st.isReified());
        m.removeReification(rs2);
        AbstractTestReifiedStatements.assertFalse("st should no longer be reified", st.isReified());
    }

    private void testNotReifying(Model m, String uri) {
        try {
            m.createResource(uri).as(ReifiedStatement.class);
            AbstractTestReifiedStatements.fail("there should be no reifiedStatement for " + uri);
        }
        catch (DoesNotReifyException doesNotReifyException) {
            // empty catch block
        }
    }

    public void testDoesNotReifyElsewhere() {
        String uri = "spoo:rubbish";
        Model m2 = this.getModel();
        this.model.createReifiedStatement("spoo:rubbish", this.SPO);
        this.testDoesNotReify("blue model should not reify rubbish", m2.createResource("spoo:rubbish"));
    }
}

