/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.ARP;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestErrorMsg
extends TestCase {
    public TestErrorMsg(String name) {
        super(name);
    }

    public String toString() {
        return this.getName();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(TestErrorMsg.class);
        s.setName("ARP Error Messages");
        return s;
    }

    private void check(String filename, String regexPresent, String regexAbsent) throws IOException {
        final StringBuffer buf = new StringBuffer();
        ARP arp = new ARP();
        arp.getHandlers().setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) {
                buf.append(exception.getMessage());
                buf.append("\n");
            }

            public void error(SAXParseException e2) {
                this.warning(e2);
            }

            public void fatalError(SAXParseException e2) {
                this.warning(e2);
            }
        });
        FileInputStream in = new FileInputStream("testing/arp/error-msgs/" + filename + ".rdf");
        try {
            arp.load(in, "file:///" + filename);
        }
        catch (SAXException e2) {
            // empty catch block
        }
        ((InputStream)in).close();
        String contents = buf.toString();
        if (regexPresent != null) {
            TestErrorMsg.assertTrue("Should find /" + regexPresent + "/", Pattern.compile(regexPresent, 32).matcher(contents).find());
        }
        if (regexAbsent != null) {
            TestErrorMsg.assertTrue("Should not find /" + regexAbsent + "/", !Pattern.compile(regexAbsent, 32).matcher(contents).find());
        }
        contents = null;
    }

    public void testErrMsg01() throws Exception {
        this.check("test01", null, "Unusual");
    }

    public void testErrMsg02() throws Exception {
        this.check("test02", "parseType", "Unusual");
    }

    public void testErrMsg03() throws Exception {
        this.check("test03", "parseType", "Unusual");
    }

    public void testErrMsg04a() throws Exception {
        this.check("test04", null, "Unusual");
    }

    public void testErrMsg04b() throws Exception {
        this.check("test04", null, "parseType");
    }

    public void testErrMsg05() throws Exception {
        this.check("test05", null, "Unusual");
    }

    public void testUTF8() throws Exception {
        this.check("testutf8", "UTF", "Unusual");
    }
}

