/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states.test;

import com.hp.hpl.jena.rdf.arp.states.test.EventList;
import com.hp.hpl.jena.rdf.arp.states.test.EventRecord;
import com.hp.hpl.jena.rdf.arp.states.test.FullEventRecord;
import com.hp.hpl.jena.rdf.arp.states.test.TestData;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestEventList
extends TestCase
implements Test {
    final EventRecord record1;
    final EventRecord record2;
    static EventRecord dummyEvent = new EventRecord();

    public TestEventList(String nm, EventRecord r1, EventRecord r2) {
        super(nm);
        this.record1 = r1;
        this.record2 = r2;
    }

    private void check(String start, EventRecord first, EventRecord second) {
        Class f = TestData.toState(start);
        String[] ev = new String[first.startEvents.length + second.startEvents.length];
        System.arraycopy(first.startEvents, 0, ev, 0, first.startEvents.length);
        System.arraycopy(second.startEvents, 0, ev, first.startEvents.length, second.startEvents.length);
        EventList events = new EventList(ev);
        events.expectAnException(second.rsltState.equals("!"));
        events.expectAnError(second.rsltState.equals("?"));
        events.test(f);
        if (second.rsltState.equals("!")) {
            TestEventList.assertTrue("expected an exception", events.testException);
        } else if (second.rsltState.equals("?")) {
            TestEventList.assertTrue("expected an error or warning", events.testFailure);
        } else if (events.testFailure) {
            TestEventList.fail("parse had unexpected warning or error");
        } else if (events.testException) {
            TestEventList.fail("parse had unexpected exception");
        } else {
            TestEventList.assertEquals("end state", events.testResult.getClass(), TestData.toState(second.rsltState));
            TestData.xmlHandler.check(second);
            TestData.testFrame.check(second);
        }
    }

    protected void runTest() {
        String state = this.record1 instanceof FullEventRecord ? ((FullEventRecord)this.record1).state : ((FullEventRecord)this.record2).state;
        this.check(state, this.record1, this.record2);
    }

    public static Test create(String line, String[] fields) {
        FullEventRecord ev = new FullEventRecord(fields);
        if (ev.rsltState.length() == 1) {
            return new TestEventList(line, dummyEvent, ev);
        }
        TestSuite rslt = new TestSuite();
        rslt.setName(ev.state + " " + ev.toEventString());
        rslt.addTest(new TestEventList("$ " + ev.toResultString(), dummyEvent, ev));
        for (int i = 0; i < ev.moreCharacter.length; ++i) {
            rslt.addTest(new TestEventList(ev.moreCharacter[i].toEventString() + " $ " + ev.moreCharacter[i].toResultString(), ev, ev.moreCharacter[i]));
        }
        return rslt;
    }

    static {
        TestEventList.dummyEvent.startEvents = new String[0];
    }
}

