/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.impl;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.impl.Taint;
import com.hp.hpl.jena.rdf.arp.impl.TaintImpl;
import com.hp.hpl.jena.rdf.arp.impl.XMLBaselessContext;
import com.hp.hpl.jena.rdf.arp.impl.XMLContext;
import com.hp.hpl.jena.rdf.arp.impl.XMLHandler;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTag;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagCodes;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagSyntaxException;
import java.util.Iterator;
import org.xml.sax.SAXParseException;

public abstract class AbsXMLContext
implements ARPErrorNumbers,
LanguageTagCodes {
    protected final String lang;
    protected final Taint langTaint;
    final Taint baseTaint;
    protected final IRI uri;
    protected final AbsXMLContext document;

    protected AbsXMLContext(boolean useDoc, AbsXMLContext document, IRI uri, Taint baseT, String lang, Taint langT) {
        this.lang = lang;
        this.langTaint = langT;
        this.baseTaint = baseT;
        this.uri = uri;
        this.document = useDoc ? (document == null ? this : document) : null;
    }

    protected static Taint initTaint(XMLHandler h, IRI base) throws SAXParseException {
        TaintImpl rslt = new TaintImpl();
        AbsXMLContext.checkURI(h, rslt, base);
        return rslt;
    }

    public AbsXMLContext withBase(XMLHandler forErrors, String b) throws SAXParseException {
        TaintImpl taintB = new TaintImpl();
        IRI newB = this.resolveAsURI(forErrors, taintB, b, false);
        if (newB.isRelative()) {
            return new XMLBaselessContext(forErrors, 215, newB.create(""));
        }
        if (newB.hasViolation(false)) {
            return new XMLBaselessContext(forErrors, 214, newB);
        }
        return new XMLContext(this.keepDocument(forErrors), this.document, newB.create(""), taintB, this.lang, this.langTaint);
    }

    abstract boolean keepDocument(XMLHandler var1);

    protected AbsXMLContext withLang(XMLHandler forErrors, String l) throws SAXParseException {
        TaintImpl taint = new TaintImpl();
        this.checkXMLLang(forErrors, taint, l);
        return this.clone(this.uri, this.baseTaint, l, taint);
    }

    abstract AbsXMLContext clone(IRI var1, Taint var2, String var3, Taint var4);

    public String getLang(Taint taint) {
        if (this.langTaint.isTainted()) {
            taint.taint();
        }
        return this.lang;
    }

    final IRI resolveAsURI(XMLHandler forErrors, Taint taintMe, String relUri) throws SAXParseException {
        return this.resolveAsURI(forErrors, taintMe, relUri, true);
    }

    final IRI resolveAsURI(XMLHandler forErrors, Taint taintMe, String relUri, boolean checkBaseUse) throws SAXParseException {
        IRI rslt = this.uri.create(relUri);
        if (checkBaseUse) {
            this.checkBaseUse(forErrors, taintMe, relUri, rslt);
        }
        AbsXMLContext.checkURI(forErrors, taintMe, rslt);
        return rslt;
    }

    abstract void checkBaseUse(XMLHandler var1, Taint var2, String var3, IRI var4) throws SAXParseException;

    protected static void checkURI(XMLHandler forErrors, Taint taintMe, IRI rslt) throws SAXParseException {
        if (rslt.hasViolation(false)) {
            Iterator it = rslt.violations(false);
            while (it.hasNext()) {
                Violation irie = (Violation)it.next();
                String msg = irie.getShortMessage();
                String uri = rslt.toString();
                if (irie.getViolationCode() == 58 && irie.getComponent() == 2) {
                    if (forErrors.allowRelativeURIs()) continue;
                    forErrors.warning(taintMe, 136, "Relative URIs are not permitted in RDF: specifically <" + rslt.toString() + ">");
                    continue;
                }
                forErrors.warning(taintMe, 107, "Bad URI: " + msg);
            }
        }
    }

    public String resolve(XMLHandler forErrors, Taint taintMe, String u) throws SAXParseException {
        return this.resolveAsURI(forErrors, taintMe, u, true).toString();
    }

    private void checkXMLLang(XMLHandler arp, Taint taintMe, String newLang) throws SAXParseException {
        if (newLang.equals("")) {
            return;
        }
        try {
            LanguageTag tag = new LanguageTag(newLang);
            int tagType = tag.tagType();
            if (tagType == 32768) {
                arp.warning(taintMe, 116, tag.errorMessage());
            }
            if ((tagType & 0x200) == 512) {
                arp.warning(taintMe, 116, "Unnecessary use of language tag \"und\" prohibited by RFC3066");
            }
            if ((tagType & 0x2000) == 8192) {
                arp.warning(taintMe, 117, "Use of deprecated language tag \"" + newLang + "\".");
            }
            if ((tagType & 2) == 2) {
                arp.warning(taintMe, 1, "Use of (IANA) private language tag \"" + newLang + "\".");
            } else if ((tagType & 0x800) == 2048) {
                arp.warning(taintMe, 1, "Use of (ISO639-2) local use language tag \"" + newLang + "\".");
            } else if ((tagType & 0x80) == 128) {
                arp.warning(taintMe, 1, "Use of additional private subtags on language \"" + newLang + "\".");
            }
        }
        catch (LanguageTagSyntaxException e2) {
            arp.warning(taintMe, 115, e2.getMessage());
        }
    }
}

