/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.resultset.JSONInput;
import com.hp.hpl.jena.sparql.resultset.RDFInput;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.ResultSetFormat;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.resultset.ResultSetRewindable;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.resultset.SortedResultSet;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.util.FileManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetFactory {
    static Log log = LogFactory.getLog(ResultSetFactory.class);

    public static ResultSet load(String filenameOrURI) {
        return ResultSetFactory.load(filenameOrURI, null);
    }

    public static ResultSet load(String filenameOrURI, ResultSetFormat format) {
        if (format == null) {
            format = ResultSetFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            log.warn("Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            log.fatal("Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultSetFormat.syntaxXML) || format.equals(ResultSetFormat.syntaxJSON) || format.equals(ResultSetFormat.syntaxRDF_N3) || format.equals(ResultSetFormat.syntaxRDF_XML) || format.equals(ResultSetFormat.syntaxRDF_TURTLE)) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(filenameOrURI);
            }
            catch (FileNotFoundException ex) {
                throw new NotFoundException("File: " + filenameOrURI);
            }
            return ResultSetFactory.load(in, format);
        }
        log.warn("Unknown result set syntax: " + format);
        return null;
    }

    public static ResultSet load(InputStream input, ResultSetFormat format) {
        if (format == null) {
            log.warn("Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            log.fatal("Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultSetFormat.syntaxXML)) {
            return ResultSetFactory.fromXML(input);
        }
        if (format.equals(ResultSetFormat.syntaxRDF_XML)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null);
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultSetFormat.syntaxRDF_TURTLE)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "TURTLE");
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultSetFormat.syntaxRDF_N3)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "N3");
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultSetFormat.syntaxJSON)) {
            return JSONInput.fromJSON(input);
        }
        log.warn("Unknown result set syntax: " + format);
        return null;
    }

    public static Model loadAsModel(String filenameOrURI) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, null);
    }

    public static Model loadAsModel(Model model, String filenameOrURI) {
        return ResultSetFactory.loadAsModel(model, filenameOrURI, null);
    }

    public static Model loadAsModel(String filenameOrURI, ResultSetFormat format) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, format);
    }

    public static Model loadAsModel(Model model, String filenameOrURI, ResultSetFormat format) {
        if (model == null) {
            model = GraphUtils.makeDefaultModel();
        }
        if (format == null) {
            format = ResultSetFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            log.warn("Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            log.fatal("Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultSetFormat.syntaxXML) || format.equals(ResultSetFormat.syntaxJSON)) {
            InputStream in = null;
            try {
                in = FileManager.get().open(filenameOrURI);
                if (in == null) {
                    throw new NotFoundException(filenameOrURI);
                }
            }
            catch (NotFoundException ex) {
                throw new NotFoundException("File not found: " + filenameOrURI);
            }
            SPARQLResult x = null;
            x = format.equals(ResultSetFormat.syntaxJSON) ? JSONInput.make(in, GraphUtils.makeDefaultModel()) : XMLInput.make(in, GraphUtils.makeDefaultModel());
            if (x.isResultSet()) {
                ResultSetFormatter.asRDF(model, x.getResultSet());
            } else {
                ResultSetFormatter.asRDF(model, x.getBooleanResult());
            }
            return model;
        }
        if (format.isCompatibleWith(ResultSetFormat.syntaxRDF_XML)) {
            return FileManager.get().readModel(model, filenameOrURI);
        }
        log.warn("Unknown result set syntax: " + format);
        return null;
    }

    public static ResultSet fromXML(InputStream in) {
        return XMLInput.fromXML(in);
    }

    public static ResultSet fromRDF(Model model) {
        return new RDFInput(model);
    }

    public static ResultSet fromJSON(InputStream in) {
        return JSONInput.fromJSON(in);
    }

    public static ResultSet makeResults(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(ResultSet resultSet) {
        return new ResultSetMem(resultSet);
    }

    public static ResultSet makeSorted(ResultSet resultSet, List conditions) {
        return new SortedResultSet(resultSet, conditions);
    }

    public static ResultSet copyResults(ResultSet results) {
        return new ResultSetMem(results);
    }

    public static ResultSet create(QueryIterator queryIterator, List vars) {
        vars = Var.varNames(vars);
        return new ResultSetStream(vars, null, queryIterator);
    }
}

