/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import junit.framework.TestSuite;

public class TestDAMLProperty
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLProperty("TestDAMLProperty");
    }

    public TestDAMLProperty(String name) {
        super(name);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLProperty.unique"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                1.assertFalse("unique", p.isUnique());
                p.setIsUnique(true);
                1.assertTrue("unique", p.isUnique());
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_domain"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                2.assertEquals("prop_domain property", DAML_OIL.domain, p.prop_domain().getProperty());
                2.assertEquals("domain cardinality", 0, p.prop_domain().count());
                p.prop_domain().add(B);
                2.assertEquals("domain cardinality", 1, p.prop_domain().count());
                p.prop_domain().add(C);
                2.assertEquals("domain cardinality", 2, p.prop_domain().count());
                this.iteratorTest(p.prop_domain().getAll(), new Object[]{B, C});
                p.prop_domain().remove(C);
                2.assertEquals("domain cardinality", 1, p.prop_domain().count());
                this.iteratorTest(p.prop_domain().getAll(), new Object[]{B});
                2.assertTrue("hasValue", p.prop_domain().hasValue(B));
                2.assertTrue("hasValue", !p.prop_domain().hasValue(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_range"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                3.assertEquals("prop_range property", DAML_OIL.range, p.prop_range().getProperty());
                3.assertEquals("range cardinality", 0, p.prop_range().count());
                p.prop_range().add(B);
                3.assertEquals("range cardinality", 1, p.prop_range().count());
                p.prop_range().add(C);
                3.assertEquals("range cardinality", 2, p.prop_range().count());
                this.iteratorTest(p.prop_range().getAll(), new Object[]{B, C});
                p.prop_range().remove(C);
                3.assertEquals("range cardinality", 1, p.prop_range().count());
                this.iteratorTest(p.prop_range().getAll(), new Object[]{B});
                3.assertTrue("hasValue", p.prop_range().hasValue(B));
                3.assertTrue("hasValue", !p.prop_range().hasValue(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_subPropertyOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty q = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty r = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                4.assertEquals("prop_subPropertyOf property", DAML_OIL.subPropertyOf, p.prop_subPropertyOf().getProperty());
                4.assertEquals("subPropertyOf cardinality", 0, p.prop_subPropertyOf().count());
                p.prop_subPropertyOf().add(q);
                4.assertEquals("subPropertyOf cardinality", 1, p.prop_subPropertyOf().count());
                p.prop_subPropertyOf().add(r);
                4.assertEquals("subPropertyOf cardinality", 2, p.prop_subPropertyOf().count());
                this.iteratorTest(p.prop_subPropertyOf().getAll(), new Object[]{q, r});
                p.prop_subPropertyOf().remove(r);
                4.assertEquals("subPropertyOf cardinality", 1, p.prop_subPropertyOf().count());
                this.iteratorTest(p.prop_subPropertyOf().getAll(), new Object[]{q});
                4.assertTrue("hasValue", p.prop_subPropertyOf().hasValue(q));
                4.assertTrue("hasValue", !p.prop_subPropertyOf().hasValue(r));
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSubProperties"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty q = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty r = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                r.prop_subPropertyOf().add(q);
                q.prop_subPropertyOf().add(p);
                5.assertEquals("subPropertyOf p", q, p.getSubProperty());
                this.iteratorTest(p.getSubProperties(), new Object[]{q});
                this.iteratorTest(p.getSubProperties(false), new Object[]{q});
                this.iteratorTest(p.getSubProperties(true), new Object[]{q});
                r.prop_subPropertyOf().add(p);
                this.iteratorTest(p.getSubProperties(), new Object[]{q, r});
                this.iteratorTest(p.getSubProperties(false), new Object[]{q});
                this.iteratorTest(p.getSubProperties(true), new Object[]{q, r});
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSuperProperties"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty q = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty r = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.prop_subPropertyOf().add(q);
                q.prop_subPropertyOf().add(r);
                6.assertEquals("superPropertyOf p", q, p.getSuperProperty());
                this.iteratorTest(p.getSuperProperties(), new Object[]{q});
                this.iteratorTest(p.getSuperProperties(false), new Object[]{q});
                this.iteratorTest(p.getSuperProperties(true), new Object[]{q});
                p.prop_subPropertyOf().add(r);
                this.iteratorTest(p.getSuperProperties(), new Object[]{q, r});
                this.iteratorTest(p.getSuperProperties(false), new Object[]{q});
                this.iteratorTest(p.getSuperProperties(true), new Object[]{q, r});
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSameProperties"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty q = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty r = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.prop_samePropertyAs().add(q);
                q.prop_samePropertyAs().add(r);
                this.iteratorTest(p.getSameProperties(), new Object[]{q});
                p.prop_samePropertyAs().add(r);
                this.iteratorTest(p.getSameProperties(), new Object[]{q, r});
            }
        }, new DAMLTestBase.OntTestCase("Datatype property"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLDatatypeProperty p = m.createDAMLDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
                8.assertNotNull(p);
            }
        }, new DAMLTestBase.OntTestCase("unambiguous property"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                9.assertFalse("p not unambiguous", p.isUnambiguous());
                p.setIsUnambiguous(true);
                9.assertTrue("p not unambiguous", p.isUnambiguous());
                p.setIsUnambiguous(false);
                9.assertFalse("p not unambiguous", p.isUnambiguous());
            }
        }, new DAMLTestBase.OntTestCase("Transitive property"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                10.assertFalse("p not Transitive", p.isTransitive());
                p.setIsTransitive(true);
                10.assertTrue("p not Transitive", p.isTransitive());
                p.setIsTransitive(false);
                10.assertFalse("p not Transitive", p.isTransitive());
            }
        }, new DAMLTestBase.OntTestCase("DAMLObjectProperty.prop_inverseOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLObjectProperty q = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                p.prop_inverseOf().add(q);
                11.assertEquals("inverse", q, p.prop_inverseOf().get());
            }
        }};
    }
}

