/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import junit.framework.TestSuite;

public class TestDAMLList
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLList("TestDAMLList");
    }

    public TestDAMLList(String name) {
        super(name);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLList.getAll"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                this.iteratorTest(l.getAll(), new Object[]{A, B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getFirst"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                2.assertEquals("DAMLList.getFirst()", A, l.getFirst());
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.cons"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{B, C});
                DAMLList l2 = l.cons(A);
                this.iteratorTest(l2.getAll(), new Object[]{A, B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getRest"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                this.iteratorTest(l.getRest().getAll(), new Object[]{B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getCount"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                5.assertEquals("count", 3, l.getCount());
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setFirst"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{B, B, C});
                l.setFirst(A);
                this.iteratorTest(l.getAll(), new Object[]{A, B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setRest"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A});
                DAMLList l2 = m.createDAMLList(new RDFNode[]{B, C});
                l.setRest(l2);
                this.iteratorTest(l.getAll(), new Object[]{A, B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setRestNil"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                l.getRest().setRestNil();
                this.iteratorTest(l.getAll(), new Object[]{A, B});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.nil"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLList l = m.createDAMLList();
                9.assertTrue("nil is nil", l.isNil(l.getNil()));
                9.assertFalse("A is not nil", l.isNil(A));
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.findLast"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                this.iteratorTest(l.findLast().getAll(), new Object[]{C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getItem"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                11.assertEquals("A", A, l.getItem(0));
                11.assertEquals("B", B, l.getItem(1));
                11.assertEquals("C", C, l.getItem(2));
            }
        }};
    }
}

