/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DAMLTestBase
extends TestSuite {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";

    public DAMLTestBase(String name) {
        super(name);
        OntTestCase[] tc = this.getTests();
        for (int i = 0; i < tc.length; ++i) {
            this.addTest(tc[i]);
        }
    }

    protected OntTestCase[] getTests() {
        return null;
    }

    protected abstract class OntTestCase
    extends TestCase {
        protected String m_langElement;

        public OntTestCase(String langElement) {
            super("DAML API test " + langElement);
            this.m_langElement = langElement;
        }

        public void setUp() {
            OntDocumentManager.getInstance().reset(true);
        }

        public void runTest() throws Exception {
            boolean profileEx = false;
            DAMLModel m = ModelFactory.createDAMLModel();
            try {
                this.doTest(m);
            }
            catch (ProfileException e2) {
                profileEx = true;
            }
            OntTestCase.assertTrue("language element " + this.m_langElement + " was  expected in DAML model ", !profileEx);
        }

        protected abstract void doTest(DAMLModel var1) throws Exception;

        protected void iteratorTest(Iterator i, Object[] expected) {
            Log logger = LogFactory.getLog(this.getClass());
            ArrayList<Object> expList = new ArrayList<Object>();
            for (int j = 0; j < expected.length; ++j) {
                expList.add(expected[j]);
            }
            while (i.hasNext()) {
                Object next = i.next();
                if (!expList.contains(next)) {
                    logger.debug(this.getName() + " - Unexpected iterator result: " + next);
                }
                OntTestCase.assertTrue("Value " + next + " was not expected as a result from this iterator ", expList.contains(next));
                OntTestCase.assertTrue("Value " + next + " was not removed from the list ", expList.remove(next));
            }
            if (expList.size() != 0) {
                logger.debug(this.getName() + "Expected iterator results not found");
                Iterator j = expList.iterator();
                while (j.hasNext()) {
                    logger.debug(this.getName() + " - missing: " + j.next());
                }
            }
            OntTestCase.assertEquals("There were expected elements from the iterator that were not found", 0, expList.size());
        }
    }
}

