/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLDataInstance;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DAMLTest
extends TestCase {
    private static Log log = LogFactory.getLog(DAMLTest.class);
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFList;

    public DAMLTest(String name) {
        super(name);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void tearDown() {
    }

    public void testLoadOntology() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("Load success status should be true", m.getLoadSuccessful());
        DAMLTest.assertEquals("Count of number of classes in daml store (2001/03, import)", 31, this.countClasses(m));
        DAMLTest.assertEquals("Property count ", 68, this.countProperties(m));
        m = this.getCleanModel();
        m.getLoader().setLoadImportedOntologies(false);
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("Load success status should be true", m.getLoadSuccessful());
        DAMLTest.assertEquals("Count of number of classes in daml store (2001/03, no import)", 16, this.countClasses(m));
        m = this.getCleanModel();
        m.read("file:testing/ontology/daml/test-instance-load.daml");
        DAMLTest.assertTrue("Load status should be true", m.getLoadSuccessful());
        Resource pugh = m.getResource("http://dickinson-i-4/daml/tests/test-instance-load.daml#pugh");
        DAMLTest.assertNotNull("Resource for officer Pugh should not be null", pugh);
        DAMLInstance pughInst = (DAMLInstance)pugh.as(DAMLInstance.class);
        DAMLTest.assertNotNull(pughInst);
        m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("Load success status should be true", m.getLoadSuccessful());
        DAMLProperty shoesize = (DAMLProperty)m.getProperty("http://www.daml.org/2001/03/daml+oil-ex#shoesize").as(DAMLProperty.class);
        DAMLTest.assertNotNull("Failed to find shoesize property in example ontology", shoesize);
        DAMLTest.assertEquals("shoesize should be a unique property", true, shoesize.isUnique());
    }

    public void testRDFType() {
        String ns = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/test-cases.daml");
        DAMLInstance fido = m.getDAMLInstance(ns + "fido");
        DAMLTest.assertNotNull("fido instance should not be null", fido);
        DAMLClass cDog = m.getDAMLClass(ns + "Dog");
        DAMLTest.assertNotNull("Dog class should not be null", cDog);
        DAMLClass cVertebrate = m.getDAMLClass(ns + "Vertebrate");
        DAMLTest.assertNotNull("Vertebrate class should not be null", cVertebrate);
        DAMLClass cPet = m.getDAMLClass(ns + "Pet");
        DAMLTest.assertNotNull("Pet class should not be null", cPet);
        DAMLTest.assertTrue("fido should be member of class Dog", fido.hasRDFType(cDog));
        DAMLTest.assertTrue("fido should be member of class Vertebrate", fido.hasRDFType(cVertebrate));
        DAMLTest.assertTrue("fido should be member of class Vertebrate (by URL)", fido.hasRDFType(ns + "Vertebrate"));
        DAMLTest.assertTrue("fido should be member of class Pet", fido.hasRDFType(cPet));
        DAMLTest.assertTrue("fido should not be a class", !fido.hasRDFType(DAML_OIL.Class));
        DAMLTest.assertTrue("fido should be a companion", fido.hasRDFType(ns + "Companion"));
        DAMLClass cA = m.getDAMLClass(ns + "A");
        DAMLTest.assertNotNull("Class A should not be null", cA);
        DAMLClass cB = m.getDAMLClass(ns + "B");
        DAMLTest.assertNotNull("Class B should not be null", cB);
        DAMLInstance ab = m.getDAMLInstance(ns + "ab");
        DAMLTest.assertNotNull("Instance ab should not be null", ab);
        DAMLTest.assertTrue("ab should be an A", ab.hasRDFType(cA));
        DAMLTest.assertTrue("ab should be a B", ab.hasRDFType(cB));
        DAMLTest.assertEquals("Number of classes fido belongs to (closure) should be 8", 8, this.countIteration(fido.getRDFTypes(true), true, "fido member of class "));
        DAMLTest.assertEquals("Number of classes fido belongs to (non-closure) should be 3", 3, this.countIteration(fido.getRDFTypes(false), true, "fido member of non-closed class "));
        DAMLProperty queenOf = m.getDAMLProperty(ns + "queen-of");
        DAMLTest.assertNotNull("queen-of property should be defined", queenOf);
        DAMLTest.assertTrue("an UnabmbiguousProperty should be an ObjectProperty", queenOf.hasRDFType(DAML_OIL.UnambiguousProperty));
        DAMLTest.assertTrue("an UnabmbiguousProperty should be an ObjectProperty", queenOf.hasRDFType(DAML_OIL.ObjectProperty));
        DAMLTest.assertTrue("an UnabmbiguousProperty should be an rdf:Property", queenOf.hasRDFType(RDF.Property));
    }

    public void testClass() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass person = m.getDAMLClass(ns + "Person");
        DAMLTest.assertNotNull("Person class should not be null", person);
        DAMLTest.assertTrue("Person should be a named class", person.isNamedClass());
        int sCount0 = this.countIteration(person.prop_subClassOf().getAll(), true, "super-class of Person (prop_subClassOf) ");
        int sCount1 = this.countIteration(person.getSuperClasses(), true, "super-class of Person (getSuperClasses) ");
        DAMLTest.assertEquals("person should have 10 super-classes (by prop_subClassOf)", 10, sCount0);
        DAMLTest.assertEquals("person should have 9 super-classes (by getSuperClasses)", 9, sCount1);
        DAMLTest.assertEquals("person should have 3 sub-classes", 3, this.countIteration(person.getSubClasses(), true, "Person super-class of: "));
        DAMLTest.assertTrue("Person should be a disjoint union", person.isDisjointUnion());
        DAMLList mw = person.prop_disjointUnionOf().getList();
        DAMLTest.assertNotNull("Value of disjoint union should not be null", mw);
        DAMLTest.assertEquals("Person should be a disjoint union of size 2", 2, mw.getCount());
        DAMLClass female = m.getDAMLClass(ns + "Female");
        DAMLTest.assertNotNull("Class Female should not be null", female);
        DAMLClass male = m.getDAMLClass(ns + "Male");
        DAMLTest.assertNotNull("Class Male should not be null", male);
        DAMLTest.assertTrue("Female should be disjoint with male", female.prop_disjointWith().hasValue(male));
        DAMLClass humanBeing = m.getDAMLClass(ns + "HumanBeing");
        DAMLTest.assertNotNull("Class humanBeing should not be null", humanBeing);
        DAMLTest.assertTrue("Person should be same class as HumanBeing", humanBeing.prop_sameClassAs().hasValue(person));
        DAMLClass tallMan = m.getDAMLClass(ns + "TallMan");
        DAMLTest.assertNotNull("Class TallMan should not be null", tallMan);
        DAMLList tm = tallMan.prop_intersectionOf().getList();
        DAMLTest.assertNotNull("Value of intersection should not be null", tm);
        DAMLTest.assertEquals("Tall man should be an intersection of size 2", 2, tm.getCount());
        DAMLClass car = m.getDAMLClass(ns + "Car");
        DAMLTest.assertNotNull("Class Car should not be null", car);
        DAMLClass carSuper = (DAMLClass)car.getSuperClasses(false).next();
        DAMLTest.assertNotNull("Car should have a super-class", carSuper);
        DAMLTest.assertTrue("Car super-class should be a complement", carSuper.isComplement());
        DAMLTest.assertTrue("Car super-class should be a complement of Person", carSuper.prop_complementOf().hasValue(person));
        DAMLClass height = m.getDAMLClass(ns + "Height");
        DAMLTest.assertNotNull("Class Height should not be null", height);
        DAMLTest.assertTrue("Height should be an enumeration", height.isEnumeration());
        DAMLTest.assertEquals("Height should be an enumeration of 3 elements", 3, height.prop_oneOf().getList().getCount());
        DAMLModel m0 = this.getCleanModel();
        m0.getLoader().setLoadImportedOntologies(true);
        m0.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        String tcNs = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass subClassBug0 = m0.getDAMLClass(tcNs + "SubClassBug0");
        DAMLClass subClassBug1 = m0.getDAMLClass(tcNs + "SubClassBug1");
        DAMLTest.assertNotNull("Class SubClassBug0 should not be null", subClassBug0);
        DAMLTest.assertNotNull("Class SubClassBug1 should not be null", subClassBug1);
        DAMLTest.assertTrue("SubClassBug1 should have SubClassBug0 as a super-class", subClassBug1.hasSuperClass(subClassBug0));
        DAMLTest.assertTrue("SubClassBug0 should have SubClassBug1 as a sub-class", subClassBug0.hasSubClass(subClassBug1));
        DAMLClass defProp0 = m0.getDAMLClass(tcNs + "DefProp0");
        DAMLClass defProp1 = m0.getDAMLClass(tcNs + "DefProp1");
        DAMLClass defProp2 = m0.getDAMLClass(tcNs + "DefProp2");
        DAMLTest.assertNotNull("Class DefProp0 should not be null", defProp0);
        DAMLTest.assertNotNull("Class DefProp1 should not be null", defProp1);
        DAMLTest.assertNotNull("Class DefProp2 should not be null", defProp2);
        int nP0 = this.countIteration(defProp0.getDefinedProperties(), true, "Defined property of DefProp0, closed");
        int nP0nc = this.countIteration(defProp0.getDefinedProperties(false), true, "Defined property of DefProp0, not closed");
        int nP1 = this.countIteration(defProp1.getDefinedProperties(), true, "Defined property of DefProp1, closed");
        int nP1nc = this.countIteration(defProp1.getDefinedProperties(false), true, "Defined property of DefProp1, not closed");
        int nP2 = this.countIteration(defProp2.getDefinedProperties(), true, "Defined property of DefProp2, closed");
        int nP2nc = this.countIteration(defProp2.getDefinedProperties(false), true, "Defined property of DefProp2, not closed");
        DAMLTest.assertEquals("Defined properties of DefProp0 should number 11", 11, nP0);
        DAMLTest.assertEquals("Defined properties of DefProp0 (non-closed) should number 11", 11, nP0nc);
        DAMLTest.assertEquals("Defined properties of DefProp1 should number 11", 11, nP1);
        DAMLTest.assertEquals("Defined properties of DefProp1 (non-closed) should number 0", 0, nP1nc);
        DAMLTest.assertEquals("Defined properties of DefProp2 should number 12", 12, nP2);
        DAMLTest.assertEquals("Defined properties of DefProp2 (non-closed) should number 1", 1, nP2nc);
        DAMLTest.assertEquals("Defined properties of DefProp2 should number 12", 12, nP2);
        DAMLTest.assertEquals("Defined properties of DefProp2 (non-closed) should number 1", 1, nP2nc);
        DAMLClass tl_one = m0.getDAMLClass(tcNs + "tl_one");
        DAMLTest.assertNotNull("Class tl_one should not be null", tl_one);
        int tl_one_supers0 = this.countIteration(tl_one.prop_subClassOf().getAll(), true, "prop_subClassOf ");
        int tl_one_supers1 = this.countIteration(tl_one.getSuperClasses(false), true, "getSuperClasses ");
        DAMLTest.assertEquals("Should be four super-classes of tl_one by prop_subClassOf", 4, tl_one_supers0);
        DAMLTest.assertEquals("Should be two super-classes of tl_one by getSuperClasses", 2, tl_one_supers1);
        DAMLClass researcher = m0.getDAMLClass(tcNs + "Researcher");
        DAMLTest.assertNotNull("Class Researcher should not be null", researcher);
        int researcherSupers = this.countIteration(researcher.getSuperClasses(false), true, "Super-class of researcher");
        DAMLTest.assertEquals("Should be 2 super-classes of researcher", 2, researcherSupers);
    }

    public void testEquivalence() {
        String ns = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLInstance root = m.getDAMLInstance(ns + "x0");
        DAMLTest.assertNotNull("Instance x0 should not be null", root);
        DAMLTest.assertEquals("Number of elements in equivalence class should be 1", 1, this.countIteration(root.getEquivalentValues(), true, "Member of equivalence class to x0: "));
        DAMLClass cRoot = m.getDAMLClass(ns + "C0");
        DAMLTest.assertNotNull("Class C0 should not be null", cRoot);
        DAMLTest.assertEquals("Number of elements in equivalence class should be 1", 1, this.countIteration(cRoot.getSameClasses(), true, "sameClass as C0: "));
        DAMLProperty pRoot = m.getDAMLProperty(ns + "p0");
        DAMLTest.assertNotNull("Property p0 should not be null", pRoot);
        DAMLTest.assertEquals("Number of elements in equivalence class should be 1", 1, this.countIteration(pRoot.getSameProperties(), true, "sameProperty as p0: "));
        Resource dClass = m.getResource(ns + "CDaml");
        DAMLTest.assertNotNull("Resource dClass should not be null", dClass);
        DAMLTest.assertTrue("Resource dClass should be a daml class", dClass.canAs(DAMLClass.class));
        DAMLClass cD0 = m.getDAMLClass(ns + "D0");
        DAMLClass cD1 = m.getDAMLClass(ns + "D1");
        DAMLInstance d1 = m.getDAMLInstance(ns + "d1");
        DAMLTest.assertNotNull("Class D0 should not be null", cD0);
        DAMLTest.assertNotNull("Class D1 should not be null", cD1);
        DAMLTest.assertNotNull("Instance d1 should not be null", d1);
        DAMLTest.assertTrue("Instance d1 should have class D1", d1.hasRDFType(cD1));
        DAMLProperty pd0 = m.getDAMLProperty(ns + "pd0");
        DAMLProperty pd1 = m.getDAMLProperty(ns + "pd1");
        DAMLTest.assertNotNull("Property pd0 should not be null", pd0);
        DAMLTest.assertNotNull("Property pd1 should not be null", pd1);
        DAMLInstance d2 = m.getDAMLInstance(ns + "d2");
        DAMLTest.assertNotNull("Instance d2 should not be null", d2);
        DAMLTest.assertTrue("d2 should have d1 as a value for pd0", d2.accessProperty(pd0).hasValue(d1));
        DAMLProperty pd2 = m.getDAMLProperty(ns + "pd2");
        DAMLProperty pd3 = m.getDAMLProperty(ns + "pd3");
        DAMLTest.assertNotNull("Property pd2 should not be null", pd2);
        DAMLTest.assertNotNull("Property pd3 should not be null", pd3);
        DAMLTest.assertTrue("d2 should have d1 as a value for pd3", d2.accessProperty(pd3).hasValue(d1));
        DAMLTest.assertTrue("d2 should have d1 as a value for pd2", d2.accessProperty(pd2).hasValue(d1));
    }

    public void testProperty() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLProperty hasMother = m.getDAMLProperty(ns + "hasMother");
        DAMLTest.assertNotNull("hasMother property should not be null", hasMother);
        DAMLTest.assertTrue("hasMother property should be a unique property", hasMother.isUnique());
        DAMLProperty hasParent = m.getDAMLProperty(ns + "hasParent");
        DAMLTest.assertNotNull("hasParent property should not be null", hasParent);
        DAMLClass female = m.getDAMLClass(ns + "Female");
        DAMLTest.assertNotNull("Class Female should not be null", female);
        DAMLClass animal = m.getDAMLClass(ns + "Animal");
        DAMLTest.assertNotNull("Class Animal should not be null", animal);
        DAMLClass person = m.getDAMLClass(ns + "Person");
        DAMLTest.assertNotNull("Class Person should not be null", person);
        DAMLTest.assertTrue("Mother should have Female as range", hasMother.prop_range().hasValue(female));
        DAMLTest.assertTrue("Mother should not have Animal as local domain (prop_domain)", !hasMother.prop_domain().hasValue(animal));
        DAMLObjectProperty hasAncestor = (DAMLObjectProperty)m.getDAMLProperty(ns + "hasAncestor").as(DAMLObjectProperty.class);
        DAMLTest.assertNotNull("hasAncestor should not be null", hasAncestor);
        DAMLTest.assertTrue("hasAncestor should be transitive", hasAncestor.isTransitive());
        DAMLInstance peter = m.getDAMLInstance(ns + "Peter");
        DAMLTest.assertNotNull("Instance Peter should not be null", peter);
        DAMLProperty shoesize = m.getDAMLProperty(ns + "shoesize");
        DAMLTest.assertNotNull("Property shoesize should not be null", shoesize);
        PropertyAccessor paShoesize = peter.accessProperty(shoesize);
        NodeIterator iShoes = paShoesize.getAll();
        DAMLTest.assertEquals("iShoes iterator should have at least one value", true, iShoes.hasNext());
        Object size = iShoes.next();
        DAMLTest.assertNotNull("size returned from property accessor iterator should not be null", size);
        DAMLTest.assertTrue("size object should be a literal", size instanceof Literal);
        boolean nse = false;
        try {
            iShoes.next();
        }
        catch (NoSuchElementException ignore) {
            nse = true;
        }
        DAMLTest.assertEquals("Accessing past end of property iterator should throw no such element exception", true, nse);
        NodeIterator iSubClassOf = person.prop_subClassOf().getAll();
        DAMLTest.assertNotNull("Iterator over subClassOf values should not be null", iSubClassOf);
        DAMLTest.assertTrue("Iteration of subClassOf should have at least one value", iSubClassOf.hasNext());
        int nSupers = this.countIteration(iSubClassOf, true, "direct super-class of Person = ");
        DAMLTest.assertEquals("Should be 10 super-classes of Person", 10, nSupers);
        DAMLClass male = m.getDAMLClass(ns + "Male");
        DAMLTest.assertNotNull("Class Male should not be null", male);
        DAMLCommon femaleDisjoint = (DAMLCommon)female.prop_disjointWith().get();
        DAMLTest.assertNotNull("Value for female.disjointWith should not be null", femaleDisjoint);
        DAMLTest.assertTrue("female.disjointWith should be male", male.equals(femaleDisjoint));
        m.getLoader().setLoadImportedOntologies(false);
        m.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        ns = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass subClassCheck3 = (DAMLClass)m.getDAMLValue(ns + "subClassCheck3").as(DAMLClass.class);
        DAMLTest.assertNotNull("Class subClassCheck3 should not be null", subClassCheck3);
        ExtendedIterator iSubClassOf3 = subClassCheck3.getSuperClasses(false);
        DAMLTest.assertNotNull("Iterator over subClassOf values should not be null", iSubClassOf);
        DAMLTest.assertTrue("Iteration of subClassOf should have at least one value", iSubClassOf3.hasNext());
        nSupers = this.countIteration(iSubClassOf3, true, "property access on subClassCheck3");
        DAMLTest.assertEquals("Should be 1 non-closed super-classes of subClassCheck3", 1, nSupers);
        iSubClassOf3 = subClassCheck3.getSuperClasses(true);
        DAMLTest.assertNotNull("Iterator over subClassOf values should not be null", iSubClassOf);
        DAMLTest.assertTrue("Iteration of subClassOf should have at least one value", iSubClassOf3.hasNext());
        nSupers = this.countIteration(iSubClassOf3, true, "property access on subClassCheck3 with closed = true ");
        DAMLTest.assertEquals("Should be 3 closed super-classes of subClassCheck3", 3, nSupers);
        DAMLProperty q = m.getDAMLProperty(ns + "q");
        DAMLTest.assertNotNull("Property q should not be null", q);
        DAMLInstance qX = m.getDAMLInstance(ns + "qX");
        DAMLTest.assertNotNull("Instance qX should not be null", qX);
        int nQ = qX.accessProperty(q).count();
        DAMLTest.assertEquals("There should be 1 values for q of qX (equivalence off)", 1, nQ);
        DAMLObjectProperty tlPropTest = (DAMLObjectProperty)m.getDAMLProperty(ns + "TL_PropertyTest").as(DAMLObjectProperty.class);
        DAMLTest.assertNotNull("Property should not be null", tlPropTest);
        NodeIterator tl_domains = tlPropTest.prop_domain().getAll();
        DAMLTest.assertEquals("Property TL_PropertyTest should have a domain of two classes", 2, this.countIteration(tl_domains, false, null));
        NodeIterator tl_ranges = tlPropTest.prop_range().getAll();
        DAMLTest.assertEquals("Property TL_PropertyTest should have a range of two classes", 2, this.countIteration(tl_ranges, false, null));
        DAMLClass humanBody = (DAMLClass)m.getDAMLValue(ns + "HumanBody").as(DAMLClass.class);
        DAMLTest.assertNotNull("Class humanBody should not be null", humanBody);
        PropertyAccessor propUnion = humanBody.prop_unionOf();
        DAMLTest.assertNotNull("Property accessor should not be null", propUnion);
        DAMLTest.assertEquals("Should be two value in union", 1, propUnion.count());
        DAMLCommon union = propUnion.getDAMLValue();
        DAMLTest.assertNotNull("Union should not be null", union);
        DAMLTest.assertTrue("Union value should be a list", union.canAs(DAMLList.class));
        DAMLTest.assertEquals("Should be two values in list", 2, ((DAMLList)union.as(DAMLList.class)).getCount());
    }

    public void testList() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass person = m.getDAMLClass(ns + "Person");
        DAMLTest.assertNotNull("Person class should not be null", person);
        DAMLClass man = m.getDAMLClass(ns + "Man");
        DAMLTest.assertNotNull("Man class should not be null", man);
        DAMLClass woman = m.getDAMLClass(ns + "Woman");
        DAMLTest.assertNotNull("Woman class should not be null", woman);
        DAMLList union = (DAMLList)person.prop_disjointUnionOf().get().as(DAMLList.class);
        DAMLTest.assertNotNull("union should not be null", union);
        DAMLTest.assertEquals("union should have two values", 2, union.getCount());
        RDFNode val1 = union.getFirst();
        DAMLTest.assertEquals("Man should be the first element in the list", man, val1);
        DAMLList tail = union.getRest();
        DAMLTest.assertNotNull("Tail of list should not be null", tail);
        RDFNode val2 = tail.getFirst();
        DAMLTest.assertNotNull("head of tail should not be null", val2);
        DAMLTest.assertEquals("Woman should be the first element in the tail of the list", woman, val2);
        DAMLList tail2 = tail.getRest();
        DAMLTest.assertNotNull("Tail of tail should not be null", tail2);
        DAMLTest.assertTrue("Remainder of list should be empty", tail2.isEmpty());
        DAMLClass car = m.getDAMLClass(ns + "Car");
        DAMLTest.assertNotNull("Class Car should not be null", car);
        union.add(car);
        DAMLTest.assertEquals("Union should contain three elements", 3, union.getCount());
    }

    public void testInstance() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLTest.assertEquals("Number of instances should be 7", 7, this.countIteration(m.listDAMLInstances(), false, " instance = "));
        DAMLClass person = m.getDAMLClass(ns + "Person");
        DAMLTest.assertNotNull("Person DAML class should not be null", person);
        int nPerson = this.countIteration(person.getInstances(), true, "instance of person");
        DAMLTest.assertEquals("There should be 4 instances of Person in the model", 4, nPerson);
    }

    public void testDatatype() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLInstance ian = m.getDAMLInstance(ns + "Ian");
        DAMLTest.assertNotNull("Instance Ian should not be null", ian);
        DAMLProperty shirtsize = m.getDAMLProperty(ns + "shirtsize");
        DAMLTest.assertNotNull("Property shirtsize should not be null", shirtsize);
        DAMLProperty shoesize = m.getDAMLProperty(ns + "shoesize");
        DAMLTest.assertNotNull("Property shoesize should not be null", shoesize);
        DAMLDataInstance sSize = (DAMLDataInstance)ian.getRequiredProperty(shirtsize).getObject().as(DAMLDataInstance.class);
        DAMLTest.assertNotNull("Object ian should have a shirtsize", sSize);
        Object x = sSize.getValue();
        DAMLTest.assertNotNull("Value of shirtsize should not be null", x);
        DAMLTest.assertEquals("Shirt size should be a string", String.class, x.getClass());
        DAMLTest.assertEquals("Shirt size should be \"12\"", (Object)"12", x);
    }

    public void testDataInstance() {
        DAMLModel m = this.getCleanModel();
        DAMLDataInstance di = m.createDAMLDataInstance(new Integer(9));
        DAMLTest.assertNotNull("Failed to create data instance ", di);
        DAMLTest.assertEquals("data instance URI not correct ", TypeMapper.getInstance().getTypeByName(XSD.xint.getURI()), di.getDatatype());
        String NS = "http://example.org/eg#";
        DAMLClass person = m.createDAMLClass(NS + "Person");
        DAMLInstance peter = m.createDAMLInstance(person, NS + "peter");
        DAMLDatatypeProperty p = m.createDAMLDatatypeProperty(NS + "shirtsize");
        peter.addProperty((Property)p, di);
    }

    public void testRemove() {
        DAMLCommon c;
        DAMLModel m = ModelFactory.createDAMLModel();
        m.getDocumentManager().setProcessImports(false);
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        ArrayList cache = new ArrayList();
        this.checkValidLists(m, "baseline");
        ExtendedIterator i = m.listDAMLClasses();
        while (i.hasNext()) {
            cache.add(i.next());
        }
        while (!cache.isEmpty()) {
            c = (DAMLClass)cache.remove(0);
            log.debug("Removing class " + c);
            c.remove();
            this.checkValidLists(m, "remove class");
        }
        i = m.listDAMLInstances();
        while (i.hasNext()) {
            cache.add(i.next());
        }
        while (!cache.isEmpty()) {
            c = (DAMLInstance)cache.remove(0);
            log.debug("Removing instance " + c);
            c.remove();
            this.checkValidLists(m, "remove instance");
        }
        i = m.listDAMLProperties();
        while (i.hasNext()) {
            cache.add(i.next());
        }
        while (!cache.isEmpty()) {
            c = (DAMLProperty)cache.remove(0);
            log.debug("Removing property " + c);
            c.remove();
            this.checkValidLists(m, "remove property");
        }
        boolean notBuiltin = false;
        ExtendedIterator i2 = m.listDAMLClasses();
        while (i2.hasNext()) {
            Resource x = (Resource)i2.next();
            if (((Object)x).equals(DAML_OIL.Thing) || ((Object)x).equals(DAML_OIL.Nothing) || x.hasProperty(DAML_OIL.complementOf, DAML_OIL.Nothing)) continue;
            log.debug("Unexpected class remains: " + x);
            StmtIterator j = x.listProperties();
            while (j.hasNext()) {
                log.debug(" ... has prop " + j.next());
            }
            notBuiltin = true;
        }
        DAMLTest.assertFalse("Should be no more classes", notBuiltin);
        DAMLTest.assertFalse("Should be no more properties", m.listDAMLProperties().hasNext());
        DAMLTest.assertFalse("Should be no more instances", m.listDAMLInstances().hasNext());
    }

    public void testCreate() {
        DAMLModel m = this.getCleanModel();
        String cURI = "http://dickinson-i-4/daml/tests/gen#A";
        DAMLClass c = m.createDAMLClass(cURI);
        DAMLTest.assertNotNull("Failed to create new DAML Class " + cURI, c);
        boolean found = false;
        ExtendedIterator i = m.listDAMLClasses();
        while (i.hasNext()) {
            if (!((DAMLClass)i.next()).equals(c)) continue;
            found = true;
        }
        DAMLTest.assertTrue("Could not see class after it was created", found);
        DAMLInstance x = (DAMLInstance)m.createDAMLValue("http://dickinson-i-4/daml/tests/gen#x", c);
        DAMLTest.assertNotNull("Failed to create new DAML instance", x);
        found = false;
        ExtendedIterator i2 = m.listDAMLInstances();
        while (i2.hasNext()) {
            if (!((DAMLInstance)i2.next()).equals(x)) continue;
            found = true;
        }
        DAMLTest.assertTrue("Could not see instance after it was created", found);
    }

    public void testRestriction() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass person = m.getDAMLClass(ns + "Person");
        ExtendedIterator i = person.getSuperClasses();
        while (i.hasNext()) {
            DAMLRestriction restriction;
            PropertyAccessor onPropertyAccessor;
            int count;
            Resource r = (Resource)i.next();
            if (!(r instanceof DAMLRestriction) || (count = (onPropertyAccessor = (restriction = (DAMLRestriction)r).prop_onProperty()).count()) < 1) continue;
            RDFNode x = onPropertyAccessor.get();
            Object y = onPropertyAccessor.getAll().next();
            DAMLTest.assertNotNull("Failed to access value of property accessor on restriction", x);
            DAMLTest.assertNotNull("Failed to access value of property accessor on restriction", y);
        }
    }

    public void testModelAdd() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/test-add-0.daml");
        DAMLTest.assertTrue("loadStatus should be true for successful load", m.getLoadSuccessful());
        Model m0 = ModelFactory.createDefaultModel();
        m0.read("file:testing/ontology/daml/test-add-1.daml");
        DAMLTest.assertEquals("Instance count in DAML model should be 0", 0, this.countIteration(m.listDAMLInstances(), true, "instance in test add"));
        m.add(m0);
        DAMLTest.assertEquals("Instance count in DAML model should be 1", 1, this.countIteration(m.listDAMLInstances(), true, "instance in test add"));
    }

    public void testDatatypeProperty() {
        this.eqTest(new EqualityTest("DatatypeProperty"){

            String xml() {
                return "<daml:DatatypeProperty/>";
            }

            void java(DAMLModel m) {
                m.createDAMLDatatypeProperty(null);
            }
        });
    }

    public void testObjectProperty() {
        this.eqTest(new EqualityTest("ObjectProperty"){

            String xml() {
                return "<daml:ObjectProperty/>";
            }

            void java(DAMLModel m) {
                m.createDAMLObjectProperty(null);
            }
        });
    }

    public void testPropertyEq() {
        this.eqTest(new EqualityTest("Property"){

            String xml() {
                return "<daml:Property/>";
            }

            void java(DAMLModel m) {
                m.createDAMLProperty(null);
            }
        });
    }

    public void testDatatypeEq2() {
        this.eqTest(new EqualityTest("Datatype"){

            String xml() {
                return "<daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#string'/>";
            }

            void java(DAMLModel m) {
                m.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#string");
            }
        });
    }

    public void testDatatypeRange() {
        this.eqTest(new EqualityTest("Datatype Range"){

            String xml() {
                return "<daml:DatatypeProperty rdf:ID='shoesize'> <rdf:type rdf:resource='http://www.daml.org/2001/03/daml+oil#UniqueProperty'/> <daml:range rdf:resource='http://www.w3.org/2000/10/XMLSchema#decimal'/></daml:DatatypeProperty><daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#decimal'/>";
            }

            void java(DAMLModel m) {
                DAMLDatatypeProperty shoeSize = m.createDAMLDatatypeProperty("http://example.org/#shoesize");
                shoeSize.setIsUnique(true);
                shoeSize.prop_range().add(m.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#decimal"));
            }
        });
    }

    private void eqTest(EqualityTest test) {
        DAMLModel m1 = this.getCleanModel();
        test.java(m1);
        Model m2 = ModelFactory.createDefaultModel();
        StringReader rdr = new StringReader("<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#' xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>" + test.xml() + "</rdf:RDF>");
        m2.read(rdr, "http://example.org/");
        if (!m1.getBaseModel().isIsomorphicWith(m2)) {
            System.out.println("Java:");
            m1.write(System.out, "RDF/XML-ABBREV");
            System.out.println("XML:");
            m2.write(System.out, "RDF/XML-ABBREV");
        }
        DAMLTest.assertTrue("java code and xml should be equivalent", m1.getBaseModel().isIsomorphicWith(m2));
    }

    public void dumpModel(Model m) {
        this.dumpModel(m, "model-out.rdf");
    }

    public void dumpModel(Model m, String fileName) {
        try {
            FileOutputStream f = new FileOutputStream(fileName);
            m.write(f, "RDF/XML-ABBREV");
            ((OutputStream)f).close();
        }
        catch (Exception e2) {
            LogFactory.getLog(this.getClass()).debug("Exception while dumping model: " + e2, e2);
        }
    }

    private int countIteration(Iterator i, boolean doLog, String message) {
        int count = 0;
        while (i.hasNext()) {
            Object x = i.next();
            if (doLog) {
                LogFactory.getLog(this.getClass()).debug("counting iteration, " + message + x);
            }
            ++count;
        }
        return count;
    }

    private int countClasses(DAMLModel m) {
        return this.countIteration(m.listDAMLClasses(), true, "class = ");
    }

    private int countProperties(DAMLModel m) {
        return this.countIteration(m.listDAMLProperties(), true, "property = ");
    }

    private DAMLModel getCleanModel() {
        DAMLModel m = ModelFactory.createDAMLModel();
        m.getDocumentManager().setProcessImports(true);
        m.getDocumentManager().clearCache();
        m.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        ArrayList ll = new ArrayList();
        Iterator i = m.getImportModelMaker().listModels();
        while (i.hasNext()) {
            ll.add(i.next());
        }
        i = ll.iterator();
        while (i.hasNext()) {
            String mName = (String)i.next();
            m.getImportModelMaker().removeModel(mName);
            log.debug("Removing " + mName);
        }
        return m;
    }

    private void checkValidLists(Model m, String label) {
        log.debug("Checking lists in DAMLTest - " + label);
        StmtIterator i = m.listStatements();
        while (i.hasNext()) {
            Statement s = i.nextStatement();
            RDFNode n = s.getObject();
            if (!(n instanceof Resource) || !((Resource)n).canAs(class$com$hp$hpl$jena$rdf$model$RDFList == null ? DAMLTest.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList) || ((RDFList)n.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? DAMLTest.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList)).isValid()) continue;
            log.debug("!!Found invalid list in " + label + " - " + n);
            DAMLTest.assertTrue("DAML list not valid ", false);
        }
    }

    private static abstract class EqualityTest {
        String name;

        EqualityTest(String nm) {
            this.name = nm;
        }

        public String toString() {
            return this.name;
        }

        abstract void java(DAMLModel var1);

        abstract String xml();
    }
}

