/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLDataInstance;
import com.hp.hpl.jena.ontology.daml.DAMLDatatype;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLOntology;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.impl.DAMLClassImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLDatatypePropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLListImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLLoader;
import com.hp.hpl.jena.ontology.daml.impl.DAMLObjectPropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLOntologyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLRestrictionImpl;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;

public class DAMLModelImpl
extends OntModelImpl
implements DAMLModel {
    protected static Object[][] DAML_CLASS_TABLE = new Object[][]{{DAML_OIL.Class, DAMLClassImpl.class}, {RDFS.Class, DAMLClassImpl.class}, {DAML_OIL.Restriction, DAMLRestrictionImpl.class}, {DAML_OIL.List, DAMLListImpl.class}, {DAML_OIL.Ontology, DAMLOntologyImpl.class}, {DAML_OIL.Property, DAMLPropertyImpl.class}, {RDF.Property, DAMLPropertyImpl.class}, {DAML_OIL.DatatypeProperty, DAMLDatatypePropertyImpl.class}, {DAML_OIL.ObjectProperty, DAMLObjectPropertyImpl.class}, {DAML_OIL.UniqueProperty, DAMLPropertyImpl.class}, {DAML_OIL.TransitiveProperty, DAMLObjectPropertyImpl.class}, {DAML_OIL.UnambiguousProperty, DAMLObjectPropertyImpl.class}};
    private DAMLLoader m_loader = new DAMLLoader(this);

    public DAMLModelImpl(OntModelSpec spec, Model m) {
        super(spec, m);
        this.initStore();
    }

    public DAMLOntology createDAMLOntology(String uri) {
        return (DAMLOntology)this.createOntResource(DAMLOntology.class, this.getProfile().ONTOLOGY(), uri);
    }

    public DAMLInstance createDAMLInstance(DAMLClass damlClass, String uri) {
        return (DAMLInstance)this.createOntResource(DAMLInstance.class, damlClass, uri);
    }

    public DAMLDataInstance createDAMLDataInstance(Resource datatype, Object value) {
        return this.createDAMLDataInstance(TypeMapper.getInstance().getTypeByName(datatype.getURI()), value);
    }

    public DAMLDataInstance createDAMLDataInstance(RDFDatatype datatype, Object value) {
        Resource bNode = this.createResource(this.getResource(datatype.getURI()));
        bNode.addProperty(RDF.value, this.createTypedLiteral(value, datatype));
        return (DAMLDataInstance)bNode.as(DAMLDataInstance.class);
    }

    public DAMLDataInstance createDAMLDataInstance(Object value) {
        RDFDatatype datatype = TypeMapper.getInstance().getTypeByValue(value);
        if (datatype == null) {
            throw new JenaException("Could not determine an appropriate datatype for value " + value);
        }
        return this.createDAMLDataInstance(datatype, value);
    }

    public DAMLClass createDAMLClass(String uri) {
        return (DAMLClass)this.createOntResource(DAMLClass.class, this.getProfile().CLASS(), uri);
    }

    public DAMLProperty createDAMLProperty(String uri) {
        return (DAMLProperty)this.createOntResource(DAMLProperty.class, this.getProfile().PROPERTY(), uri);
    }

    public DAMLObjectProperty createDAMLObjectProperty(String uri) {
        return (DAMLObjectProperty)this.createOntResource(DAMLObjectProperty.class, this.getProfile().OBJECT_PROPERTY(), uri);
    }

    public DAMLDatatypeProperty createDAMLDatatypeProperty(String uri) {
        return (DAMLDatatypeProperty)this.createOntResource(DAMLDatatypeProperty.class, this.getProfile().DATATYPE_PROPERTY(), uri);
    }

    public DAMLList createDAMLList() {
        return (DAMLList)this.getResource(DAML_OIL.nil.getURI()).as(DAMLList.class);
    }

    public DAMLList createDAMLList(Iterator elements) {
        DAMLList l = this.createDAMLList();
        if (elements.hasNext()) {
            RDFNode n = (RDFNode)elements.next();
            l = (DAMLList)l.cons(n);
            while (elements.hasNext()) {
                l.add((RDFNode)elements.next());
            }
        }
        return l;
    }

    public DAMLList createDAMLList(RDFNode[] elements) {
        return this.createDAMLList(Arrays.asList(elements).iterator());
    }

    public DAMLRestriction createDAMLRestriction(String uri) {
        return (DAMLRestriction)this.createOntResource(DAMLRestriction.class, this.getProfile().RESTRICTION(), uri);
    }

    public DAMLDatatype createDAMLDatatype(String uri) {
        Resource dt = this.getResource(uri);
        dt.addProperty(RDF.type, DAML_OIL.Datatype);
        return (DAMLDatatype)dt.as(DAMLDatatype.class);
    }

    public DAMLCommon createDAMLValue(String uri, Resource damlClass) {
        Class javaClass = DAMLInstance.class;
        for (int i = 0; i < DAML_CLASS_TABLE.length; ++i) {
            if (!DAML_CLASS_TABLE[i][0].equals(damlClass)) continue;
            javaClass = (Class)DAML_CLASS_TABLE[i][1];
            break;
        }
        return (DAMLCommon)this.createOntResource(javaClass, damlClass, uri);
    }

    public DAMLCommon getDAMLValue(String uri) {
        Node n = Node.createURI(uri);
        if (this.getGraph().queryHandler().containsNode(n)) {
            return (DAMLCommon)((Resource)this.asRDFNode(n)).as(DAMLCommon.class);
        }
        return null;
    }

    public DAMLCommon getDAMLValue(String uri, DAMLClass damlClass) {
        DAMLCommon res = this.getDAMLValue(uri);
        return res == null && damlClass != null ? this.createDAMLValue(uri, damlClass) : res;
    }

    public ExtendedIterator listDAMLClasses() {
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().CLASS(), null, DAMLClass.class));
    }

    public ExtendedIterator listDAMLProperties() {
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().PROPERTY(), null, DAMLProperty.class));
    }

    public ExtendedIterator listDAMLInstances() {
        return UniqueExtendedIterator.create(this.listIndividuals().mapWith(new Map1(){

            public Object map1(Object x) {
                return ((Resource)x).as(class$com$hp$hpl$jena$ontology$daml$DAMLInstance == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLInstance = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLInstance")) : class$com$hp$hpl$jena$ontology$daml$DAMLInstance);
            }
        }));
    }

    public DAMLClass getDAMLClass(String uri) {
        Node n = Node.createURI(uri);
        if (this.getGraph().queryHandler().containsNode(n)) {
            return (DAMLClass)((Resource)this.asRDFNode(n)).as(DAMLClass.class);
        }
        return null;
    }

    public DAMLProperty getDAMLProperty(String uri) {
        Node n = Node.createURI(uri);
        if (this.getGraph().queryHandler().containsNode(n)) {
            return (DAMLProperty)((Resource)this.asRDFNode(n)).as(DAMLProperty.class);
        }
        return null;
    }

    public DAMLInstance getDAMLInstance(String uri) {
        Node n = Node.createURI(uri);
        if (this.getGraph().queryHandler().containsNode(n)) {
            return (DAMLInstance)((Resource)this.asRDFNode(n)).as(DAMLInstance.class);
        }
        return null;
    }

    public Model read(String uri, String base, String lang) {
        try {
            URL url = new URL(uri);
            return this.read(url.openStream(), base, lang);
        }
        catch (IOException e2) {
            throw new OntologyException("I/O error while reading from uri " + uri);
        }
    }

    public DAMLLoader getLoader() {
        return this.m_loader;
    }

    public boolean getLoadSuccessful() {
        return this.getLoader().getStatus() == 0L;
    }

    public TypeMapper getDatatypeRegistry() {
        return TypeMapper.getInstance();
    }

    public void setUseEquivalence(boolean useEquivalence) {
    }

    public boolean getUseEquivalence() {
        return true;
    }

    protected void initStore() {
    }

    protected boolean containsResource(String uri) {
        return this.containsResource(this.getResource(uri));
    }
}

