/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.test.N3ExternalTestsCom;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class N3JenaWriterTests
extends N3ExternalTestsCom {
    static final String uriBase = "http://host/base/";

    public static TestSuite suite() {
        return new N3JenaWriterTests();
    }

    public N3JenaWriterTests() {
        this("n3-writer-tests");
    }

    public N3JenaWriterTests(String filename) {
        super("N3 Jena Writer tests", filename);
    }

    protected void makeTest(String inputFile, String resultsFile) {
        String testName = inputFile;
        if (this.basedir != null) {
            inputFile = this.basedir + "/" + inputFile;
        }
        if (this.basedir != null && resultsFile != null && !resultsFile.equals("")) {
            resultsFile = this.basedir + "/" + resultsFile;
        }
        this.addTest(new Test(testName, inputFile, resultsFile, "N3-PP"));
        this.addTest(new Test(testName, inputFile, resultsFile, "N3-PLAIN"));
        this.addTest(new Test(testName, inputFile, resultsFile, "N3-TRIPLES"));
    }

    static class Test
    extends TestCase {
        String writerName = null;
        String testName = null;
        String basename = null;
        String inputFile = null;
        String resultsFile = null;
        Reader data = null;

        Test(String _testName, String _inputFile, String _resultsFile, String wName) {
            super("N3 Jena Writer test: " + _testName + "-" + wName);
            this.testName = _testName;
            this.inputFile = _inputFile;
            this.resultsFile = _resultsFile;
            this.writerName = wName;
        }

        protected void runTest() throws Throwable {
            try {
                this.data = N3ExternalTestsCom.makeReader(new FileInputStream(this.inputFile));
            }
            catch (IOException ioEx) {
                Test.fail("File does not exist: " + this.inputFile);
                return;
            }
            Model model_1 = ModelFactory.createDefaultModel();
            model_1.read(this.data, N3JenaWriterTests.uriBase, "N3");
            StringWriter w = new StringWriter();
            model_1.write(w, this.writerName, N3JenaWriterTests.uriBase);
            w.close();
            StringReader r = new StringReader(w.toString());
            Model model_2 = ModelFactory.createDefaultModel();
            model_2.read(r, N3JenaWriterTests.uriBase, "N3");
            if (!model_1.isIsomorphicWith(model_2)) {
                System.out.println("#### ---- " + this.testName + " ------------------------------");
                System.out.println("#### Model 1 ---- " + this.testName + " ------------------------------");
                model_1.write(System.out, "N3");
                System.out.println("#### Model 2 --- " + this.testName + " ------------------------------");
                model_2.write(System.out, "N3");
                Test.assertTrue("Models don't match: " + this.testName, false);
            }
        }
    }
}

