/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.JenaURIException;
import com.hp.hpl.jena.n3.RelativeURIException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.cache.Cache;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;

public class RelURI {
    private static String globalBase = null;
    static Cache baseCache = new Cache1();
    static Pattern patternHttp = Pattern.compile("^http://[^/]*/[^/]+");
    static Pattern patternFile = Pattern.compile("^file:/*[^/]+/");

    public static String resolve(String relStr, String baseStr) {
        if (relStr.equals(".") && (baseStr.startsWith("http://") || baseStr.startsWith("file:/"))) {
            if (baseStr.endsWith("/")) {
                return baseStr;
            }
            if (patternHttp.matcher(baseStr).find()) {
                int j = baseStr.lastIndexOf("/");
                return baseStr.substring(0, j + 1);
            }
            if (patternFile.matcher(baseStr).find()) {
                int j = baseStr.lastIndexOf("/");
                return baseStr.substring(0, j + 1);
            }
        }
        baseStr = CodecHex.encode(baseStr);
        relStr = CodecHex.encode(relStr);
        String s = RelURI._resolve(relStr, baseStr);
        s = CodecHex.decode(s);
        return s;
    }

    private static String _resolve(String relStr, String baseStr) {
        URI abs2;
        URI rel = null;
        try {
            rel = new URI(relStr);
        }
        catch (URISyntaxException ex) {
            throw new JenaURIException("Illegal URI: " + relStr);
        }
        if (rel.isAbsolute()) {
            String s = rel.getScheme();
            if (rel.getScheme().equals("file")) {
                return RelURI._resolveFileURL(relStr);
            }
            return relStr;
        }
        if (baseStr == null) {
            if (rel.isAbsolute()) {
                return relStr;
            }
            throw new JenaURIException("Null base for relative URI resolution: " + relStr);
        }
        if (baseStr.length() == 0) {
            throw new JenaURIException("Empty base for relative URI resolution");
        }
        if (baseStr.indexOf(35) >= 0) {
            int i = baseStr.indexOf(35);
            baseStr = baseStr.substring(0, i);
        }
        if (baseStr.endsWith(":")) {
            return RelURI.resolve(baseStr + relStr);
        }
        if (relStr.equals("")) {
            return baseStr;
        }
        URI base = (URI)baseCache.get(baseStr);
        if (base == null) {
            try {
                base = new URI(baseStr);
            }
            catch (URISyntaxException ex) {
                throw new JenaURIException("Illegal URI (base): " + baseStr);
            }
            if (!base.isAbsolute()) {
                throw new RelativeURIException("Relative URI for base: " + baseStr);
            }
            if (base.isOpaque()) {
                if (base.getScheme().equals("file") && relStr.startsWith("#")) {
                    return baseStr + relStr;
                }
                throw new RelativeURIException("Can't resolve a relative URI against an opaque URI: rel=" + relStr + " : base=" + baseStr);
            }
            baseCache.put(baseStr, base);
        }
        if (base.getPath().length() == 0 && !relStr.startsWith("/")) {
            try {
                base = new URI(baseStr + "/");
            }
            catch (URISyntaxException ex) {
                LogFactory.getLog(RelURI.class).fatal("Base now illegal fixing up path-less base URI (" + baseStr + ")");
                throw new JenaURIException("Illegal URI (base) ptII: " + baseStr);
            }
        }
        if ((abs2 = RelURI.resolve(rel, base)) == null) {
            return null;
        }
        String s = abs2.toString();
        if (s.startsWith("file:")) {
            s = RelURI._resolveFileURL(s);
        }
        return s;
    }

    private static URI resolve(URI rel, URI base) {
        try {
            URI abs2 = base.resolve(rel);
            if (!abs2.isAbsolute()) {
                return null;
            }
            return abs2;
        }
        catch (RuntimeException ex) {
            LogFactory.getLog(RelURI.class).warn("\nException in Java library: " + ex.getMessage() + "\nresolve(" + rel.toString() + ", " + base.toString() + ")");
            throw ex;
        }
    }

    public static String resolve(String relURI) {
        if (globalBase == null) {
            globalBase = RelURI.chooseBaseURI();
        }
        return RelURI.resolve(relURI, globalBase);
    }

    public static void setBaseURI(String uriBase) {
        if (uriBase != null && uriBase.startsWith("file:/") && !uriBase.startsWith("file:///")) {
            LogFactory.getLog(RelURI.class).warn("setBaseURI: File URIs should look like 'file:///path' (or at least file://host/path)");
        }
        globalBase = uriBase;
    }

    public static String getBaseURI() {
        return globalBase;
    }

    public static String chooseBaseURI() {
        return RelURI.chooseBaseURI(null);
    }

    public static String chooseBaseURI(String baseURI) {
        String scheme;
        if (baseURI == null) {
            baseURI = "file:.";
        }
        if ((scheme = FileUtils.getScheme(baseURI)) == null) {
            scheme = "file";
            baseURI = "file:" + baseURI;
        }
        if (scheme.equals("file") && !baseURI.startsWith("file:///")) {
            try {
                String tmp = baseURI.substring("file:".length());
                File f = new File(tmp);
                String s = f.getCanonicalPath();
                s = s.replace('\\', '/');
                if (s.indexOf(32) >= 0) {
                    s = s.replaceAll(" ", "%20");
                }
                baseURI = s.startsWith("/") ? "file://" + s : "file:///" + s;
                if (f.isDirectory() && !baseURI.endsWith("/")) {
                    baseURI = baseURI + "/";
                }
            }
            catch (IOException ex) {
                LogFactory.getLog(RelURI.class).warn("IOException in chooseBase - ignored");
                return null;
            }
        }
        return baseURI;
    }

    private static String _resolveFileURL(String fn) {
        fn = CodecHex.decode(fn);
        fn = RelURI.resolveFileURL(fn);
        fn = CodecHex.encode(fn);
        return fn;
    }

    public static String resolveFileURL(String filename) {
        String s = filename;
        if (s.indexOf(92) > -1) {
            s = s.replace('\\', '/');
        }
        if (s.startsWith("file:///")) {
            return s;
        }
        if (s.startsWith("file://")) {
            return s;
        }
        if (s.startsWith("file:/")) {
            s = filename.substring("file:/".length());
            return "file:///" + s;
        }
        if (s.startsWith("file:")) {
            s = filename.substring("file:".length());
        }
        s = RelURI.absFileNameURL(s);
        return s;
    }

    public static String absFileNameURL(String fn) {
        File f = new File(fn);
        if (fn.endsWith("/")) {
            fn = f.getAbsolutePath() + "/";
        } else {
            try {
                fn = f.getCanonicalPath();
            }
            catch (IOException ex) {
                return null;
            }
        }
        fn = fn.replace('\\', '/');
        fn = fn.startsWith("/") ? "file://" + fn : "file:///" + fn;
        return fn;
    }

    static class Cache1
    implements Cache {
        boolean isEnabled = true;
        Object cacheKey = null;
        Object cacheValue = null;
        int numGet = 0;
        int numPut = 0;
        int numHits = 0;

        Cache1() {
        }

        public Object get(Object key) {
            if (!this.isEnabled) {
                return null;
            }
            ++this.numGet;
            if (this.cacheKey == null) {
                return null;
            }
            if (this.cacheKey.equals(key)) {
                ++this.numHits;
                return this.cacheValue;
            }
            return null;
        }

        public void put(Object key, Object value) {
            if (!this.isEnabled) {
                return;
            }
            ++this.numPut;
            this.cacheKey = key;
            this.cacheValue = value;
        }

        public boolean getEnabled() {
            return this.isEnabled;
        }

        public boolean setEnabled(boolean enabled) {
            boolean b = this.isEnabled;
            this.isEnabled = enabled;
            return b;
        }

        public void clear() {
            this.cacheKey = null;
            this.cacheValue = null;
        }

        public long getGets() {
            return this.numGet;
        }

        public long getPuts() {
            return this.numPut;
        }

        public long getHits() {
            return this.numHits;
        }
    }

    public static class CodecHex {
        private static char[] chars = new char[]{' ', '_'};

        public static String encode(String s) {
            if (s == null) {
                return s;
            }
            StringBuffer sb = new StringBuffer();
            block0: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                for (int j = 0; j < chars.length; ++j) {
                    if (ch != chars[j]) continue;
                    sb.append('_');
                    sb.append(Integer.toHexString(ch & 0xFF));
                    continue block0;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public static String decode(String s) {
            if (s == null) {
                return s;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '_') {
                    if (i >= s.length() - 2) {
                        throw new IllegalArgumentException("Broken encoded string: " + s);
                    }
                    char ch2 = s.charAt(++i);
                    char ch3 = s.charAt(++i);
                    char ch4 = (char)((CodecHex.hexDecode(ch2) << 4) + CodecHex.hexDecode(ch3));
                    sb.append(ch4);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        private static char hexEncode(int i) {
            if (i < 10) {
                return (char)(48 + i);
            }
            return (char)(65 + i - 10);
        }

        private static int hexDecode(char b) {
            switch (b) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return (b & 0xFF) - 97 + 10;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    return b - 65 + 10;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return b - 48;
                }
            }
            throw new IllegalArgumentException("Bad Hex escape character: " + (b & 0xFF));
        }
    }
}

