/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.faster;

import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.faster.FasterTripleStore;
import com.hp.hpl.jena.mem.faster.GraphMemFasterQueryHandler;
import com.hp.hpl.jena.mem.faster.ProcessedTriple;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class GraphMemFaster
extends GraphMemBase {
    public GraphMemFaster() {
        this(ReificationStyle.Minimal);
    }

    public GraphMemFaster(ReificationStyle style) {
        super(style);
    }

    protected TripleStore createTripleStore() {
        return new FasterTripleStore(this);
    }

    protected void destroy() {
        this.store.close();
    }

    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.store.add(t);
        }
    }

    public void performDelete(Triple t) {
        if (!this.getReifier().handledRemove(t)) {
            this.store.delete(t);
        }
    }

    public int graphBaseSize() {
        return this.store.size();
    }

    public QueryHandler queryHandler() {
        if (this.queryHandler == null) {
            this.queryHandler = new GraphMemFasterQueryHandler(this);
        }
        return this.queryHandler;
    }

    public ExtendedIterator graphBaseFind(TripleMatch m) {
        return this.store.find(m.asTriple());
    }

    public Applyer createApplyer(ProcessedTriple pt) {
        Applyer plain = ((FasterTripleStore)this.store).createApplyer(pt);
        return GraphMemFaster.matchesReification(pt) && this.hasReifications() ? this.withReification(plain, pt) : plain;
    }

    protected boolean hasReifications() {
        return this.reifier != null && this.reifier.size() > 0;
    }

    public static boolean matchesReification(QueryTriple pt) {
        return pt.P.node.isVariable() || Reifier.Util.isReificationPredicate(pt.P.node) || Reifier.Util.isReificationType(pt.P.node, pt.O.node);
    }

    protected Applyer withReification(final Applyer plain, final QueryTriple pt) {
        return new Applyer(){

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                plain.applyToTriples(d, m, next);
                Triple tm = new Triple(pt.S.finder(d), pt.P.finder(d), pt.O.finder(d));
                ExtendedIterator it = GraphMemFaster.this.reifier.findExposed(tm);
                while (it.hasNext()) {
                    if (!m.match(d, (Triple)it.next())) continue;
                    next.run(d);
                }
            }
        };
    }

    public boolean graphBaseContains(Triple t) {
        return t.isConcrete() ? this.store.contains(t) : super.graphBaseContains(t);
    }

    public void clear() {
        this.store.clear();
        ((SimpleReifier)this.getReifier()).clear();
    }
}

