/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MoreTests
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite("Additional IRI Tests");
        suite.addTest(new MoreTests("testRelativizeFrag1"));
        suite.addTest(new MoreTests("testRelativizeFrag2"));
        return suite;
    }

    public MoreTests(String s) {
        super(s);
    }

    public void testRelativizeFrag1() {
        IRIFactory f = IRIFactory.jenaImplementation();
        IRI base = f.create("http://example.org/somefolder/mybase.rdf");
        IRI frag = f.create("http://example.org#foo");
        IRI rel = base.relativize(frag);
        MoreTests.assertEquals(frag, rel);
        IRI back = base.resolve(rel);
        MoreTests.assertEquals(frag, back);
    }

    public void testRelativizeFrag2() {
        IRIFactory f = IRIFactory.jenaImplementation();
        IRI base = f.create("http://example.org/somefolder/mybase.rdf");
        IRI frag = f.create("http://example.org/#foo");
        IRI rel = base.relativize(frag);
        MoreTests.assertEquals("/#foo", rel.toString());
        IRI back = base.resolve(rel);
        MoreTests.assertEquals(frag, back);
    }
}

