/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import junit.framework.TestSuite;

public class TestTriple
extends GraphTestBase {
    private static final String U = "http://some.domain.name/magic/spells.incant";
    private static final String N = "Alice";
    private static final LiteralLabel L = new LiteralLabel("ashes are burning", "en", false);

    public TestTriple(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTriple.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTripleEquals() {
        try {
            Node.cache(false);
            AnonId id = AnonId.create();
            LiteralLabel L2 = new LiteralLabel(id.toString(), "", false);
            String U2 = id.toString();
            String N2 = id.toString();
            Node[] nodes = new Node[]{Node.ANY, Node.createAnon(id), Node.createAnon(), Node.createLiteral(L), Node.createLiteral(L2), Node.createURI(U), Node.createURI(U2), Node.createVariable(N), Node.createVariable(N2)};
            Triple[] triples = new Triple[nodes.length * nodes.length * nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                for (int j = 0; j < nodes.length; ++j) {
                    for (int k = 0; k < nodes.length; ++k) {
                        triples[i * nodes.length * nodes.length + j * nodes.length + k] = new Triple(nodes[i], nodes[j], nodes[k]);
                    }
                }
            }
            boolean[][] expected = new boolean[triples.length][triples.length];
            for (int i1 = 0; i1 < nodes.length; ++i1) {
                for (int j1 = 0; j1 < nodes.length; ++j1) {
                    for (int k1 = 0; k1 < nodes.length; ++k1) {
                        for (int i2 = 0; i2 < nodes.length; ++i2) {
                            for (int j2 = 0; j2 < nodes.length; ++j2) {
                                for (int k2 = 0; k2 < nodes.length; ++k2) {
                                    expected[i1 * nodes.length * nodes.length + j1 * nodes.length + k1][i2 * nodes.length * nodes.length + j2 * nodes.length + k2] = nodes[i1].equals(nodes[i2]) && nodes[j1].equals(nodes[j2]) && nodes[k1].equals(nodes[k2]);
                                }
                            }
                        }
                    }
                }
            }
            TestTriple.assertEquals("triple, null", triples[0].equals(null), false);
            TestTriple.assertDiffer("triple, string", triples[0], "string");
            for (int i = 0; i < triples.length; ++i) {
                for (int j = 0; j < triples.length; ++j) {
                    if (expected[i][j]) {
                        TestTriple.assertEquals("triples " + i + ", " + j, triples[i], triples[j]);
                        continue;
                    }
                    TestTriple.assertDiffer("triples" + i + ", " + j, triples[i], triples[j]);
                }
            }
        }
        finally {
            Node.cache(true);
        }
    }

    public void testTripleCreate() {
        Node S = Node.create("s");
        Node P = Node.create("p");
        Node O = Node.create("o");
        TestTriple.assertEquals(new Triple(S, P, O), Triple.create(S, P, O));
    }

    public void testTripleCreateFromString() {
        Node S = Node.create("a");
        Node P = Node.create("_P");
        Node O = Node.create("?c");
        TestTriple.assertEquals(new Triple(S, P, O), Triple.create("a _P ?c"));
    }

    public void testTriplePrefixes() {
        Node S = Node.create("rdf:alpha");
        Node P = Node.create("dc:creator");
        Node O = Node.create("spoo:notmapped");
        Triple t = Triple.create("rdf:alpha dc:creator spoo:notmapped");
        TestTriple.assertEquals(new Triple(S, P, O), t);
    }

    public void testTripleCreationMapped() {
        PrefixMapping pm = PrefixMapping.Factory.create().setNsPrefix("a", "ftp://foo/").setNsPrefix("b", "http://spoo/");
        Triple wanted = Triple.create("ftp://foo/x http://spoo/y c:z");
        Triple got = Triple.create(pm, "a:x b:y c:z");
        TestTriple.assertEquals(wanted, got);
    }

    public void testPlainTripleMatches() {
        this.testMatches("S P O");
        this.testMatches("_S _P _O");
        this.testMatches("1 2 3");
    }

    public void testAnyTripleMatches() {
        this.testMatches("?? P O", "Z P O");
        this.testMatches("S ?? O", "S Q O");
        this.testMatches("S P ??", "S P oh");
        this.testMatches("?? ?? ??", "X Y Z");
        this.testMatches("?? ?? ??", "X Y 1");
        this.testMatches("?? ?? ??", "_X Y Z");
        this.testMatches("?? ?? ??", "X _Y Z");
    }

    private void testMatches(String triple) {
        this.testMatches(triple, triple);
    }

    private void testMatches(String pattern, String triple) {
        TestTriple.assertTrue(Triple.create(pattern).matches(Triple.create(triple)));
    }

    public void testPlainTripleDoesntMatch() {
        this.testMatchFails("S P O", "Z P O");
        this.testMatchFails("S P O", "S Q O");
        this.testMatchFails("S P O", "S P oh");
    }

    public void testAnyTripleDoesntMatch() {
        this.testMatchFails("?? P O", "S P oh");
        this.testMatchFails("S ?? O", "Z R O");
        this.testMatchFails("S P ??", "Z P oh");
    }

    public void testMatchFails(String pattern, String triple) {
        TestTriple.assertFalse(Triple.create(pattern).matches(Triple.create(triple)));
    }

    public void testMatchesNodes() {
        TestTriple.assertTrue(Triple.create("S P O").matches(TestTriple.node("S"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertTrue(Triple.create("?? P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertTrue(Triple.create("S ?? O").matches(TestTriple.node("S"), TestTriple.node("Q"), TestTriple.node("O")));
        TestTriple.assertTrue(Triple.create("S P ??").matches(TestTriple.node("S"), TestTriple.node("P"), TestTriple.node("I")));
        TestTriple.assertFalse(Triple.create("S P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertFalse(Triple.create("S P O").matches(TestTriple.node("S"), TestTriple.node("Q"), TestTriple.node("O")));
        TestTriple.assertFalse(Triple.create("S P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("I")));
    }

    public void testElementMatches() {
        TestTriple.assertTrue(Triple.create("S P O").subjectMatches(TestTriple.node("S")));
        TestTriple.assertTrue(Triple.create("S P O").predicateMatches(TestTriple.node("P")));
        TestTriple.assertTrue(Triple.create("S P O").objectMatches(TestTriple.node("O")));
        TestTriple.assertFalse(Triple.create("S P O").subjectMatches(TestTriple.node("Z")));
        TestTriple.assertFalse(Triple.create("S P O").predicateMatches(TestTriple.node("Q")));
        TestTriple.assertFalse(Triple.create("S P O").objectMatches(TestTriple.node("I")));
        TestTriple.assertTrue(Triple.create("?? P O").subjectMatches(TestTriple.node("SUB")));
        TestTriple.assertTrue(Triple.create("S ?? O").predicateMatches(TestTriple.node("PRED")));
        TestTriple.assertTrue(Triple.create("S P ??").objectMatches(TestTriple.node("OBJ")));
    }

    public void testConcrete() {
        TestTriple.assertTrue(Triple.create("S P O").isConcrete());
        TestTriple.assertTrue(Triple.create("S P 11").isConcrete());
        TestTriple.assertTrue(Triple.create("S P _X").isConcrete());
        TestTriple.assertTrue(Triple.create("S _P 11").isConcrete());
        TestTriple.assertTrue(Triple.create("_S _P _O").isConcrete());
        TestTriple.assertTrue(Triple.create("10 11 12").isConcrete());
        TestTriple.assertTrue(Triple.create("S P 11").isConcrete());
        TestTriple.assertFalse(Triple.create("?? P 11").isConcrete());
        TestTriple.assertFalse(Triple.create("S ?? 11").isConcrete());
        TestTriple.assertFalse(Triple.create("S P ??").isConcrete());
        TestTriple.assertFalse(Triple.create("?S P 11").isConcrete());
        TestTriple.assertFalse(Triple.create("S ?P 11").isConcrete());
        TestTriple.assertFalse(Triple.create("S P ?O").isConcrete());
    }

    public void testTripleToStringOrdering() {
        Triple t1 = Triple.create("subject predicate object");
        TestTriple.assertTrue("subject must be present", t1.toString().indexOf("subject") >= 0);
        TestTriple.assertTrue("subject must preceed predicate", t1.toString().indexOf("subject") < t1.toString().indexOf("predicate"));
        TestTriple.assertTrue("predicate must preceed object", t1.toString().indexOf("predicate") < t1.toString().indexOf("object"));
    }

    public void testTripleToStringQuoting() {
        Triple t1 = Triple.create("subject predicate 'object'");
        TestTriple.assertTrue(t1.toString().indexOf("\"object\"") > 0);
    }

    public void testTripleToStringWithPrefixing() {
        PrefixMapping pm = PrefixMapping.Factory.create();
        pm.setNsPrefix("spoo", "eg://domain.dom/spoo#");
        Triple t1 = Triple.create("eg://domain.dom/spoo#a b c");
        TestTriple.assertEquals("spoo:a @eh:/b eh:/c", t1.toString(pm));
    }
}

